<?php
session_start();
require_once 'auth21.php';
// Check if user is logged in
if (!isset($_SESSION['user_code'])) {
    header("Location: " . ROOT . 'login');
    exit();
}

// Get user data and check account status
$user_data = getUser($pdo);
if ($user_data['account_status'] == 'NOTSIGNEDUP') {
    header("Location: signup.php");
    exit();
}

$office_code = $_SESSION['user_code'];

// Get patients for this office
$stmt = $pdo->prepare("SELECT patient_code, patient_firstname_encrypted, patient_lastname_encrypted, case_number_encrypted,iv,salt,enc_code FROM patients WHERE office_code = ? AND status != 'DELETED'");
$stmt->execute([$office_code]);
$patients_enc = $stmt->fetchAll(PDO::FETCH_ASSOC);
$patients_enc2 = [];
$patients = [];
foreach ($patients_enc as $patient) {
    $patients_enc2['patient_firstname_encrypted'] = decryptData($patient['patient_firstname_encrypted']);
    $patients_enc2['patient_lastname_encrypted'] = decryptData($patient['patient_lastname_encrypted']);
    $iv = $patient['iv'];
    $salt = $patient['salt'];
    $enc_code = $patient['enc_code'];
    $tmp_patient = get_decrypted_data($patients_enc2,$iv,$salt,$enc_code);
    $tmp_patient['patient_code'] = $patient['patient_code'];
    $tmp_patient['case_number_encrypted'] = decryptData($patient['case_number_encrypted']);
    $patients[] = $tmp_patient;
}

// Get Labs Code
$stmt = $pdo_lab->prepare("SELECT lab_code,lab_name_encrypted,iv,salt,enc_code FROM users WHERE lab_clinics like ?");
$stmt->execute(["%". $office_code . "%"]);
$labs_enc = $stmt->fetchAll(PDO::FETCH_ASSOC);
$labs_enc2 = [];
$labs = [];
foreach ($labs_enc as $lab) {
    $labs_enc2['lab_name_encrypted'] = decryptData($lab['lab_name_encrypted']);
    $iv = $lab['iv'];
    $salt = $lab['salt'];
    $enc_code = $lab['enc_code'];
    $tmp_lab = get_decrypted_data($labs_enc2,$iv,$salt,$enc_code);
    $tmp_lab['lab_code'] = $lab['lab_code'];
    $labs[] = $tmp_lab;
}
// Get Lab Services
$stmt = $pdo_lab->prepare("SELECT service_code, service_title FROM services WHERE lab_code = ?");
$stmt->execute([$office_code]);
$services = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Get dentists (assuming you have a dentists table)
$stmt = $pdo->prepare("SELECT dentist_code, dentist_fullname_encrypted,iv,salt,enc_code FROM dentists WHERE office_code = ? AND status = 'ACTIVE'");
$stmt->execute([$office_code]);
$dentists_enc = $stmt->fetchAll(PDO::FETCH_ASSOC);
$dentists_enc2 = [];
$dentists = [];
foreach ($dentists_enc as $dentist) {
    $dentists_enc2['dentist_fullname_encrypted'] = decryptData($dentist['dentist_fullname_encrypted']);
    $iv = $dentist['iv'];
    $salt = $dentist['salt'];
    $enc_code = $dentist['enc_code'];
    $tmp_dentist = get_decrypted_data($dentists_enc2,$iv,$salt,$enc_code);
    $tmp_dentist['dentist_code'] = $dentist['dentist_code'];
    $dentists[] = $tmp_dentist;
}
if(isset($_POST['patient_selection_type'])){
    try{
        $stmt = $pdo->prepare("SELECT order_number FROM lab_orders WHERE clinic_code = ? ORDER BY id DESC LIMIT 1");
        $stmt->execute([$office_code]);
        $lastOrder = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($lastOrder) {
            $lastOrderParts = explode('-',$lastOrder['order_number']);
            $lastOrderNumber = $lastOrderParts[1];
            $newLastOrderNumber = (int)$lastOrderNumber + 1;
        } else {
            $newLastOrderNumber = 100;
        }
        $formatter = new IntlDateFormatter(
            "fa_IR@calendar=persian",
            IntlDateFormatter::FULL,
            IntlDateFormatter::NONE,
            'Asia/Tehran',
            IntlDateFormatter::TRADITIONAL,
            "yyyy"
        );
        $jalaliYear = $formatter->format(time());
        // Replace Persian digits with English digits
        $persianDigits = ['۰','۱','۲','۳','۴','۵','۶','۷','۸','۹'];
        $englishDigits = ['0','1','2','3','4','5','6','7','8','9'];

        $jalaliYearEnglish = str_replace($persianDigits, $englishDigits, $jalaliYear);

        $newLastOrder = $jalaliYearEnglish . '-' . $newLastOrderNumber;
        $uploaded_file_code = $_POST['add-file-codes'];
        $patient_selection_type = $_POST['patient_selection_type'];
        $dentist_selection_type = $_POST['dentist_selection_type'];
        $patient_code = "MANUAL";
        $manual_patient_name = "NA";
        $dentist_code = "MANUAL";
        $manual_dentist_name = "NA";
        $lab_code = $_POST['lab_code'];
        $service_code = $_POST['service_code'];
        $order_note = $_POST['order_note'];
        $clinic_code = $_POST['clinic_code'];
        $selected_teeth = $_POST['selected_teeth'];
        $order_teeth = is_array($_POST['selected_teeth'])
            ? json_encode($_POST['selected_teeth'], JSON_UNESCAPED_UNICODE)
            : $_POST['selected_teeth'];
        $selected_dentition = $_POST['selected_dentition'];
        $send_date = $_POST['send-date'];
        if($patient_selection_type == "manual"){
            $manual_patient_name = $_POST['manual_patient_name'];
        }
        else{
            $patient_code = $_POST['patient_code'];
        }
        if($dentist_selection_type == "manual"){
            $manual_dentist_name = $_POST['manual_dentist_name'];
        }
        else{
            $dentist_code = $_POST['dentist_code'];
        }
        // Generate order_code (can be anything unique, e.g. timestamp + rand)
        $order_code = uniqid("ORD") . '-' . substr(base64_encode(hash('sha256', $office_code)), 0, 20);

        // Default values
        $order_status = "NOTSENT_TO_LAB";
        $lab_stage = "NOTRECEIVED";
// Collect custom fields dynamically
        $custom_fields = [];
        foreach ($_POST as $key => $value) {
            if (strpos($key, 'custom_field_') === 0) {
                $custom_fields[str_replace('custom_field_','',$key)] = $value;
            }
        }
        $custom_fields_json = json_encode($custom_fields, JSON_UNESCAPED_UNICODE);
        $order_due_date = "";
        $order_finished_date = "";
        $current_date = date("Y-m-d H:i:s");

        // Prepare INSERT
        $stmt = $pdo->prepare("
        INSERT INTO lab_orders (
            order_code,lab_code, order_number,clinic_code, dentist_code, manual_dentist_name,
            service_code, patient_code, manual_patient_name, order_note,
            order_teeth,order_dentition, order_date, uploaded_file_code, order_status,
            lab_stage, custom_fields, order_due_date, order_finished_date, created_by, date
        ) VALUES (
            :order_code,:lab_code,:order_number, :clinic_code, :dentist_code, :manual_dentist_name,
            :service_code, :patient_code, :manual_patient_name, :order_note,
            :order_teeth,:order_dentition, :order_date, :uploaded_file_code, :order_status,
            :lab_stage, :custom_fields, :order_due_date, :order_finished_date, :created_by, :date
        )
    ");

        $stmt->execute([
            ':order_code' => $order_code,
            ':lab_code' => $lab_code,
            ':order_number' => $newLastOrder,
            ':clinic_code' => $clinic_code,
            ':dentist_code' => $dentist_code,
            ':manual_dentist_name' => encryptData($manual_dentist_name),
            ':service_code' => $service_code,
            ':patient_code' => $patient_code,
            ':manual_patient_name' => encryptData($manual_patient_name),
            ':order_note' => $order_note,
            ':order_teeth' => $order_teeth,
            ':order_dentition' => $selected_dentition,
            ':order_date' => $send_date,
            ':uploaded_file_code' => encryptData($uploaded_file_code),
            ':order_status' => $order_status,
            ':lab_stage' => $lab_stage,
            ':custom_fields' => $custom_fields_json,
            ':order_due_date' => $order_due_date,
            ':order_finished_date' => $order_finished_date,
            ':created_by' => $office_code,
            ':date' => $current_date
        ]);
        $linkCode = generateUniqueStringForRedirects();
        $link = htmlspecialchars(ROOT . 'order/' . $order_code);
        $stmt = $pdo_redirect->prepare("INSERT INTO redirects (redirect_code, redirect_location,source) VALUES (?, ?, ?)");
        $stmt->execute([$linkCode, $link , $office_code]);
        send_sms_5625($pdo,$pdo_lab,384496,['orderNum'=>$newLastOrder,'linkCode'=>$linkCode],$user_data['phone'],"DENTOPIN_OFFICE");
        echo "<script>
                window.location.href = 'orders';
              </script>";
    }
    catch (PDOException $e){
        // ❌ Error → show it
        echo "<script>
                alert('Error: " . addslashes($e->getMessage()) . "');
                window.history.back();
              </script>";
    }
}
?>

<!DOCTYPE html>
<html class="light-style layout-navbar-fixed layout-menu-fixed layout-compact" data-assets-path="../../assets/" data-template="vertical-menu-template-no-customizer" data-theme="theme-default" dir="rtl" lang="fa">

<head>
    <meta charset="utf-8" />
    <meta content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" name="viewport"/>
    <title>افزودن سفارش جدید - آزمایشگاه</title>
    <meta name="description" content="" />

    <!-- Favicon -->
    <link href="../../assets/img/favicon/favicon.ico" rel="icon" type="image/x-icon"/>

    <!-- Icons -->
    <link href="../../assets/vendor/fonts/fontawesome.css" rel="stylesheet"/>
    <link href="../../assets/vendor/fonts/tabler-icons.css" rel="stylesheet"/>
    <link href="../../assets/vendor/fonts/flag-icons.css" rel="stylesheet"/>
    <!-- Core CSS -->
    <link href="../../assets/vendor/css/rtl/core.css" rel="stylesheet"/>
    <link href="../../assets/vendor/css/rtl/theme-default.css" rel="stylesheet"/>
    <link href="../../assets/css/demo.css" rel="stylesheet"/>
    <!-- Vendors CSS -->
    <link href="../../assets/vendor/libs/node-waves/node-waves.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/typeahead-js/typeahead.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/select2/select2.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/@form-validation/form-validation.css" rel="stylesheet"/>
    <link rel="stylesheet" href="../../assets/vendor/libs/sweetalert2/sweetalert2.css" />

    <link href="../../assets/libs/flatpickr/flatpickr.css" rel="stylesheet"/>
    <link href="../../assets/libs/bootstrap-datepicker/bootstrap-datepicker.css" rel="stylesheet"/>
    <link href="../../assets/libs/jalali-datepicker/jalalidatepicker.css" rel="stylesheet" />
    <link href="../../assets/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/jquery-timepicker/jquery-timepicker.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/pickr/pickr-themes.css" rel="stylesheet"/>

    <!-- Page CSS -->
    <!-- Helpers -->
    <script src="../../assets/vendor/js/helpers.js"></script>
    <script src="../../assets/js/jquery-3.6.0.min.js"></script>
    <script src="../../assets/vendor/libs/sweetalert2/sweetalert2.js"></script>

    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Template customizer: To hide customizer set displayCustomizer value false in config.js.  -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="../../assets/js/config.js"></script>
    <!-- Better experience of RTL -->
    <link href="../../assets/css/rtl.css" rel="stylesheet"/> </head>

</head>

<body>
<!-- Layout wrapper -->
<div class="layout-wrapper layout-content-navbar">
    <div class="layout-container">

        <!-- Menu -->
        <?php include 'sidebar.php'; ?>
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page">

            <!-- Navbar -->
            <?php include 'navbar.php'; ?>
            <!-- / Navbar -->

            <!-- Content wrapper -->
            <div class="content-wrapper">
                <!-- Content -->
                <div class="container-xxl flex-grow-1 container-p-y">

                    <div class="row">
                        <!-- Order Form -->
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header sticky-element bg-label-secondary d-flex justify-content-sm-between align-items-sm-center flex-column flex-sm-row">
                                    <h5 class="card-title mb-sm-0 me-2">افزودن سفارش جدید</h5>
                                    <div class="action-btns">
                                        <button type="button" class="btn btn-label-primary me-3" onclick="history.back()">
                                            <span class="align-middle">بازگشت</span>
                                        </button>
                                        <button type="submit" form="orderForm" class="btn btn-primary">
                                            <span class="align-middle">ثبت سفارش</span>
                                        </button>
                                    </div>
                                </div>

                                <div class="card-body">
                                    <form id="orderForm" method="POST" enctype="multipart/form-data">

                                        <!-- Step 1: Patient Information -->
                                        <div class="row">
                                            <div class="col-12 pt-4">
                                                <h6 class="fw-medium">1. اطلاعات بیمار</h6>
                                            </div>
                                        </div>

                                        <div class="row g-3">
                                            <div class="col-md-6">
                                                <label class="form-label">انتخاب بیمار*</label>
                                                <!-- Patient Selection Type -->
                                                <div class="mb-2">
                                                    <div class="form-check form-check-inline">
                                                        <input class="form-check-input" type="radio" name="patient_selection_type" id="existing_patient" value="existing" checked>
                                                        <label class="form-check-label" for="existing_patient">انتخاب بیمار</label>
                                                    </div>
                                                    <div class="form-check form-check-inline">
                                                        <input class="form-check-input" type="radio" name="patient_selection_type" id="manual_patient" value="manual">
                                                        <label class="form-check-label" for="manual_patient">وارد کردن بیمار به صورت دلخواه</label>
                                                    </div>
                                                </div>

                                                <!-- Existing Patient Dropdown -->
                                                <div id="existing_patient_container">
                                                    <select name="patient_code" id="patient_select" class="form-select">
                                                        <option value="">انتخاب کنید</option>
                                                        <?php foreach ($patients as $patient): ?>
                                                            <option value="<?= htmlspecialchars($patient['patient_code']) ?>">
                                                                <?= htmlspecialchars($patient['patient_firstname_encrypted'] . ' ' . $patient['patient_lastname_encrypted'] . ' - ' . $patient['case_number_encrypted']) ?>
                                                            </option>
                                                        <?php endforeach; ?>
                                                    </select>
                                                </div>

                                                <!-- Manual Patient Input -->
                                                <div id="manual_patient_container" style="display: none;">
                                                    <input type="text" name="manual_patient_name" id="manual_patient_input" class="form-control" placeholder="نام و نام خانوادگی بیمار را وارد کنید">
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <label class="form-label">پزشک معالج*</label>
                                                <!-- Dentist Selection Type -->
                                                <div class="mb-2">
                                                    <div class="form-check form-check-inline">
                                                        <input class="form-check-input" type="radio" name="dentist_selection_type" id="existing_dentist" value="existing" checked>
                                                        <label class="form-check-label" for="existing_dentist">انتخاب پزشک</label>
                                                    </div>
                                                    <div class="form-check form-check-inline">
                                                        <input class="form-check-input" type="radio" name="dentist_selection_type" id="manual_dentist" value="manual">
                                                        <label class="form-check-label" for="manual_dentist">وارد کردن پزشک به صورت دلخواه</label>
                                                    </div>
                                                </div>

                                                <!-- Existing Dentist Dropdown -->
                                                <div id="existing_dentist_container">
                                                    <select name="dentist_code" id="dentist_select" class="form-select">
                                                        <option value="">انتخاب کنید</option>
                                                        <?php foreach ($dentists as $dentist): ?>
                                                            <option value="<?= htmlspecialchars($dentist['dentist_code']) ?>">
                                                                <?= htmlspecialchars($dentist['dentist_fullname_encrypted']) ?>
                                                            </option>
                                                        <?php endforeach; ?>
                                                    </select>
                                                </div>

                                                <!-- Manual Dentist Input -->
                                                <div id="manual_dentist_container" style="display: none;">
                                                    <input type="text" name="manual_dentist_name" id="manual_dentist_input" class="form-control" placeholder="نام پزشک معالج را وارد کنید">
                                                </div>
                                            </div>
                                        </div>

                                        <hr class="my-4 mx-n4" />

                                        <!-- Step 2: Service Information -->
                                        <div class="row">
                                            <div class="col-12">
                                                <h6 class="fw-medium">2. اطلاعات سرویس</h6>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-12 col-md-6 col-lg-4">
                                                <h6 class="mt-5 text-center">انتخاب دندان یا فک</h6>
                                                <div class="large-6 columns chart">
                                                    <div class="row">
                                                        <div class="position-relative d-flex justify-content-center align-items-center" style="height: 432px;">
                                                            <button id="secondarybtn" class="btn btn-primary" type="button" onclick="change_dentition(this)" style="position: absolute;top:45%;transform: translate(-50%, -50%);right: 0;">اصلی</button>
                                                            <button id="primarybtn" class="btn" type="button" onclick="change_dentition(this)" style="position: absolute;top:55%;transform: translate(-50%, -50%);right: 0;">شیری</button>
                                                            <!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">
                                                            <div style="margin-right: 100px;">
                                                                <button id="slctJawUBTN" class="btn btn-outline-primary" type="button" onclick="select_jaw(this,'u')" style="font-size: 12px;position: absolute;top: 30%;right: 50%;">کل فک بالا</button>
                                                                <button id="slctJawLBTN" class="btn btn-outline-primary" type="button" onclick="select_jaw(this,'l')" style="font-size: 12px;position: absolute;top: 60%;right: 49%;">کل فک پایین</button>
                                                                <div id="SecondaryDentition">
                                                                    <svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="237" height="222" style="shape-rendering:geometricPrecision; text-rendering:geometricPrecision; image-rendering:optimizeQuality; fill-rule:evenodd; clip-rule:evenodd" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 395 371">
                                                                        <style>
                                                                            text {
                                                                                font-family: Arial;
                                                                                font-size: 16px;
                                                                                font-weight: bold;
                                                                                fill: black;
                                                                                text-anchor: middle;
                                                                                dominant-baseline: middle;
                                                                            }
                                                                        </style>

                                                                        <g>
                                                                            <path id="ur1" onclick="tooth_select(this)" style="opacity:0.936;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 170.5,16.5 C 176.176,16.3339 181.843,16.5006 187.5,17C 194.813,17.6524 197.313,21.4858 195,28.5C 191.465,54.1863 179.298,59.353 158.5,44C 154.248,40.4187 150.748,36.252 148,31.5C 146.707,27.4179 147.874,24.2513 151.5,22C 157.736,19.3625 164.069,17.5292 170.5,16.5 Z" />
                                                                            <text id="tur1" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="170" y="35">1</text>
                                                                        </g>

                                                                        <g>
                                                                            <path id="ul1" onclick="tooth_select(this)" style="opacity:0.936;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 206.5,16.5 C 218.151,15.7122 229.485,17.2122 240.5,21C 247.535,25.0465 248.369,30.2131 243,36.5C 236.929,43.2457 229.762,48.4123 221.5,52C 213.996,54.1593 208.163,51.9927 204,45.5C 200.074,37.6072 198.407,29.2739 199,20.5C 201.255,18.5012 203.755,17.1679 206.5,16.5 Z" />
                                                                            <text id="tul1" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="220" y="35">1</text>
                                                                        </g>

                                                                        <g>
                                                                            <path id="ur2" onclick="tooth_select(this)" style="opacity:0.93;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 136.5,32.5 C 140.516,31.8999 144.016,32.8999 147,35.5C 151.264,43.8106 152.264,52.4773 150,61.5C 146.345,68.0702 140.845,70.2368 133.5,68C 103.245,53.5208 104.245,41.6875 136.5,32.5 Z" />
                                                                            <text id="tur2" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="140" y="50">2</text>
                                                                        </g>

                                                                        <g>
                                                                            <path id="ul2" onclick="tooth_select(this)" style="opacity:0.93;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 250.5,32.5 C 262.156,32.8822 272.323,36.8822 281,44.5C 282.894,48.8494 282.227,52.8494 279,56.5C 272.387,62.9587 264.554,66.9587 255.5,68.5C 246.388,67.5425 242.055,62.3758 242.5,53C 242.947,48.4299 243.781,43.9299 245,39.5C 245.967,36.3794 247.8,34.046 250.5,32.5 Z" />
                                                                            <text id="tul2" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="265" y="50">2</text>
                                                                        </g>

                                                                        <g>
                                                                            <path id="ur3" onclick="tooth_select(this)" style="opacity:0.941;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 100.5,55.5 C 114.509,57.6616 124.342,65.3282 130,78.5C 130.956,82.572 130.456,86.4054 128.5,90C 118.12,93.3327 107.787,92.9994 97.5,89C 88.9226,83.3861 86.756,75.8861 91,66.5C 92.654,61.3576 95.8207,57.6909 100.5,55.5 Z" />
                                                                            <text id="tur3" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="110" y="75">3</text>
                                                                        </g>

                                                                        <g>
                                                                            <path id="ul3" onclick="tooth_select(this)" style="opacity:0.941;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 288.5,55.5 C 293.247,55.1357 297.081,56.8023 300,60.5C 304.379,67.452 305.712,74.7853 304,82.5C 294.496,90.9458 283.329,94.1125 270.5,92C 265.294,91.2621 262.961,88.2621 263.5,83C 263.517,79.6171 264.35,76.4505 266,73.5C 271.673,64.9703 279.173,58.9703 288.5,55.5 Z" />
                                                                            <text id="tul3" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="285" y="75">3</text>
                                                                        </g>

                                                                        <g>
                                                                            <path id="ur4" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 94.5,90.5 C 106.243,98.3422 108.743,108.676 102,121.5C 97.5757,129.958 90.7423,132.791 81.5,130C 73.5614,127.391 67.3947,122.558 63,115.5C 59.0218,103.742 62.8551,95.9087 74.5,92C 81.3125,90.5394 87.9792,90.0394 94.5,90.5 Z" />
                                                                            <text id="tur4" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="90" y="110">4</text>
                                                                        </g>

                                                                        <g>
                                                                            <path id="ul4" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 299.5,90.5 C 306.021,90.0394 312.688,90.5394 319.5,92C 331.145,95.9087 334.978,103.742 331,115.5C 323.988,126.922 313.822,131.755 300.5,130C 294.285,125.775 290.451,119.942 289,112.5C 287.41,102.681 290.91,95.3481 299.5,90.5 Z" />
                                                                            <text id="tul4" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="305" y="110">4</text>
                                                                        </g>

                                                                        <g>
                                                                            <path id="ur5" onclick="tooth_select(this)" style="opacity:0.945;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 61.5,127.5 C 86.831,126.631 95.331,137.964 87,161.5C 80.2346,171.502 71.0679,174.336 59.5,170C 44.2257,164.287 39.059,153.787 44,138.5C 48.5194,132.661 54.3527,128.995 61.5,127.5 Z" />
                                                                            <text id="tur5" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="65" y="150">5</text>
                                                                        </g>

                                                                        <g>
                                                                            <path id="ul5" onclick="tooth_select(this)" style="opacity:0.945;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 323.5,127.5 C 332.881,126.604 341.048,129.271 348,135.5C 355.609,148.351 353.109,158.851 340.5,167C 321.514,177.248 309.348,172.081 304,151.5C 302.052,144.135 303.885,137.968 309.5,133C 314.017,130.445 318.684,128.612 323.5,127.5 Z" />
                                                                            <text id="tul5" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="330" y="150">5</text>
                                                                        </g>

                                                                        <g>
                                                                            <path id="ur6" onclick="tooth_select(this)" style="opacity:0.958;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 50.5,171.5 C 56.5281,172.077 62.5281,172.911 68.5,174C 76.1223,175.999 78.6223,180.832 76,188.5C 74.1229,198.248 71.1229,207.582 67,216.5C 62.2191,219.363 57.0524,220.196 51.5,219C 44.0164,217.698 37.0164,215.031 30.5,211C 27.6107,205.879 26.7773,200.379 28,194.5C 29.0376,186.587 32.5376,180.087 38.5,175C 42.6227,173.808 46.6227,172.641 50.5,171.5 Z" />
                                                                            <text id="tur6" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="50" y="195">6</text>
                                                                        </g>

                                                                        <g>
                                                                            <path id="ul6" onclick="tooth_select(this)" style="opacity:0.958;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 339.5,171.5 C 355.091,171.379 363.924,179.046 366,194.5C 368.888,205.903 364.721,213.07 353.5,216C 349.634,216.502 345.967,217.502 342.5,219C 337.232,220.068 332.232,219.401 327.5,217C 326.789,215.745 325.956,214.579 325,213.5C 320.902,202.119 318.568,190.452 318,178.5C 319.952,176.106 322.452,174.606 325.5,174C 330.315,173.197 334.981,172.363 339.5,171.5 Z" />
                                                                            <text id="tul6" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="340" y="195">6</text>
                                                                        </g>

                                                                        <g>
                                                                            <path id="ur7" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 31.5,219.5 C 42.8799,219.809 53.8799,221.976 64.5,226C 67.8575,228.693 69.1908,232.193 68.5,236.5C 68.037,245.877 67.2036,255.21 66,264.5C 63.538,270.487 59.038,273.654 52.5,274C 43.3932,274.793 34.3932,274.126 25.5,272C 22.0879,270.545 18.9212,268.712 16,266.5C 14.0771,263.456 13.2438,260.123 13.5,256.5C 13.8723,245.121 16.7056,234.454 22,224.5C 24.9074,222.132 28.0741,220.465 31.5,219.5 Z" />
                                                                            <text id="tur7" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="40" y="245">7</text>
                                                                        </g>

                                                                        <g>
                                                                            <path id="ul7" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 355.5,219.5 C 363.317,218.646 369.483,221.312 374,227.5C 378.702,238.714 380.702,250.381 380,262.5C 376.551,268.324 371.384,271.824 364.5,273C 355.152,274.869 345.819,274.869 336.5,273C 332.333,271.5 329.5,268.667 328,264.5C 326.395,253.217 325.728,241.884 326,230.5C 327.167,228 329,226.167 331.5,225C 339.5,222.57 347.5,220.737 355.5,219.5 Z" />
                                                                            <text id="tul7" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="355" y="245">7</text>
                                                                        </g>

                                                                        <g>
                                                                            <path id="ur8" onclick="tooth_select(this)" style="opacity:0.954;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 14.5,278.5 C 24.8387,278.334 35.172,278.5 45.5,279C 52.5535,279.721 56.7202,283.554 58,290.5C 58.2785,296.957 59.2785,303.29 61,309.5C 63.2901,316.64 61.1234,321.807 54.5,325C 43.0487,328.264 31.3821,329.264 19.5,328C 10.3639,325.948 5.86392,320.114 6,310.5C 5.33333,303.5 5.33333,296.5 6,289.5C 6.8138,284.196 9.64713,280.529 14.5,278.5 Z" />
                                                                            <text id="tur8" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="30" y="300">8</text>
                                                                        </g>

                                                                        <g>
                                                                            <path id="ul8" onclick="tooth_select(this)" style="opacity:0.954;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 348.5,278.5 C 358.839,278.334 369.172,278.5 379.5,279C 384.551,280.717 387.385,284.217 388,289.5C 389.042,299.635 388.375,309.635 386,319.5C 383.934,324.626 380.1,327.459 374.5,328C 362.618,329.264 350.951,328.264 339.5,325C 332.877,321.807 330.71,316.64 333,309.5C 334.661,301.894 335.994,294.227 337,286.5C 339.485,281.749 343.319,279.082 348.5,278.5 Z" />
                                                                            <text id="tul8" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="360" y="300">8</text>
                                                                        </g>

                                                                    </svg>
                                                                    <br>
                                                                    <svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="237" height="222" style="margin-top: -36px;shape-rendering:geometricPrecision; text-rendering:geometricPrecision; image-rendering:optimizeQuality; fill-rule:evenodd; clip-rule:evenodd" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 395 371">
                                                                        <style>
                                                                            text {
                                                                                font-family: Arial;
                                                                                font-size: 16px;
                                                                                font-weight: bold;
                                                                                fill: black;
                                                                                text-anchor: middle;
                                                                                dominant-baseline: middle;
                                                                            }
                                                                        </style>
                                                                        <!-- Rotated teeth paths -->
                                                                        <g transform="rotate(180 197.5 185.5)">
                                                                            <path id="ll1" onclick="tooth_select(this)" style="opacity:0.936;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 170.5,16.5 C 176.176,16.3339 181.843,16.5006 187.5,17C 194.813,17.6524 197.313,21.4858 195,28.5C 191.465,54.1863 179.298,59.353 158.5,44C 154.248,40.4187 150.748,36.252 148,31.5C 146.707,27.4179 147.874,24.2513 151.5,22C 157.736,19.3625 164.069,17.5292 170.5,16.5 Z" />
                                                                            <path id="lr1" onclick="tooth_select(this)" style="opacity:0.936;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 206.5,16.5 C 218.151,15.7122 229.485,17.2122 240.5,21C 247.535,25.0465 248.369,30.2131 243,36.5C 236.929,43.2457 229.762,48.4123 221.5,52C 213.996,54.1593 208.163,51.9927 204,45.5C 200.074,37.6072 198.407,29.2739 199,20.5C 201.255,18.5012 203.755,17.1679 206.5,16.5 Z" />
                                                                            <path id="ll2" onclick="tooth_select(this)" style="opacity:0.93;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 136.5,32.5 C 140.516,31.8999 144.016,32.8999 147,35.5C 151.264,43.8106 152.264,52.4773 150,61.5C 146.345,68.0702 140.845,70.2368 133.5,68C 103.245,53.5208 104.245,41.6875 136.5,32.5 Z" />
                                                                            <path id="lr2" onclick="tooth_select(this)" style="opacity:0.93;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 250.5,32.5 C 262.156,32.8822 272.323,36.8822 281,44.5C 282.894,48.8494 282.227,52.8494 279,56.5C 272.387,62.9587 264.554,66.9587 255.5,68.5C 246.388,67.5425 242.055,62.3758 242.5,53C 242.947,48.4299 243.781,43.9299 245,39.5C 245.967,36.3794 247.8,34.046 250.5,32.5 Z" />
                                                                            <path id="ll3" onclick="tooth_select(this)" style="opacity:0.941;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 100.5,55.5 C 114.509,57.6616 124.342,65.3282 130,78.5C 130.956,82.572 130.456,86.4054 128.5,90C 118.12,93.3327 107.787,92.9994 97.5,89C 88.9226,83.3861 86.756,75.8861 91,66.5C 92.654,61.3576 95.8207,57.6909 100.5,55.5 Z" />
                                                                            <path id="lr3" onclick="tooth_select(this)" style="opacity:0.941;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 288.5,55.5 C 293.247,55.1357 297.081,56.8023 300,60.5C 304.379,67.452 305.712,74.7853 304,82.5C 294.496,90.9458 283.329,94.1125 270.5,92C 265.294,91.2621 262.961,88.2621 263.5,83C 263.517,79.6171 264.35,76.4505 266,73.5C 271.673,64.9703 279.173,58.9703 288.5,55.5 Z" />
                                                                            <path id="ll4" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 94.5,90.5 C 106.243,98.3422 108.743,108.676 102,121.5C 97.5757,129.958 90.7423,132.791 81.5,130C 73.5614,127.391 67.3947,122.558 63,115.5C 59.0218,103.742 62.8551,95.9087 74.5,92C 81.3125,90.5394 87.9792,90.0394 94.5,90.5 Z" />
                                                                            <path id="lr4" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 299.5,90.5 C 306.021,90.0394 312.688,90.5394 319.5,92C 331.145,95.9087 334.978,103.742 331,115.5C 323.988,126.922 313.822,131.755 300.5,130C 294.285,125.775 290.451,119.942 289,112.5C 287.41,102.681 290.91,95.3481 299.5,90.5 Z" />
                                                                            <path id="ll5" onclick="tooth_select(this)" style="opacity:0.945;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 61.5,127.5 C 86.831,126.631 95.331,137.964 87,161.5C 80.2346,171.502 71.0679,174.336 59.5,170C 44.2257,164.287 39.059,153.787 44,138.5C 48.5194,132.661 54.3527,128.995 61.5,127.5 Z" />
                                                                            <path id="lr5" onclick="tooth_select(this)" style="opacity:0.945;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 323.5,127.5 C 332.881,126.604 341.048,129.271 348,135.5C 355.609,148.351 353.109,158.851 340.5,167C 321.514,177.248 309.348,172.081 304,151.5C 302.052,144.135 303.885,137.968 309.5,133C 314.017,130.445 318.684,128.612 323.5,127.5 Z" />
                                                                            <path id="ll6" onclick="tooth_select(this)" style="opacity:0.958;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 50.5,171.5 C 56.5281,172.077 62.5281,172.911 68.5,174C 76.1223,175.999 78.6223,180.832 76,188.5C 74.1229,198.248 71.1229,207.582 67,216.5C 62.2191,219.363 57.0524,220.196 51.5,219C 44.0164,217.698 37.0164,215.031 30.5,211C 27.6107,205.879 26.7773,200.379 28,194.5C 29.0376,186.587 32.5376,180.087 38.5,175C 42.6227,173.808 46.6227,172.641 50.5,171.5 Z" />
                                                                            <path id="lr6" onclick="tooth_select(this)" style="opacity:0.958;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 339.5,171.5 C 355.091,171.379 363.924,179.046 366,194.5C 368.888,205.903 364.721,213.07 353.5,216C 349.634,216.502 345.967,217.502 342.5,219C 337.232,220.068 332.232,219.401 327.5,217C 326.789,215.745 325.956,214.579 325,213.5C 320.902,202.119 318.568,190.452 318,178.5C 319.952,176.106 322.452,174.606 325.5,174C 330.315,173.197 334.981,172.363 339.5,171.5 Z" />
                                                                            <path id="ll7" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 31.5,219.5 C 42.8799,219.809 53.8799,221.976 64.5,226C 67.8575,228.693 69.1908,232.193 68.5,236.5C 68.037,245.877 67.2036,255.21 66,264.5C 63.538,270.487 59.038,273.654 52.5,274C 43.3932,274.793 34.3932,274.126 25.5,272C 22.0879,270.545 18.9212,268.712 16,266.5C 14.0771,263.456 13.2438,260.123 13.5,256.5C 13.8723,245.121 16.7056,234.454 22,224.5C 24.9074,222.132 28.0741,220.465 31.5,219.5 Z" />
                                                                            <path id="lr7" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 355.5,219.5 C 363.317,218.646 369.483,221.312 374,227.5C 378.702,238.714 380.702,250.381 380,262.5C 376.551,268.324 371.384,271.824 364.5,273C 355.152,274.869 345.819,274.869 336.5,273C 332.333,271.5 329.5,268.667 328,264.5C 326.395,253.217 325.728,241.884 326,230.5C 327.167,228 329,226.167 331.5,225C 339.5,222.57 347.5,220.737 355.5,219.5 Z" />
                                                                            <path id="ll8" onclick="tooth_select(this)" style="opacity:0.954;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 14.5,278.5 C 24.8387,278.334 35.172,278.5 45.5,279C 52.5535,279.721 56.7202,283.554 58,290.5C 58.2785,296.957 59.2785,303.29 61,309.5C 63.2901,316.64 61.1234,321.807 54.5,325C 43.0487,328.264 31.3821,329.264 19.5,328C 10.3639,325.948 5.86392,320.114 6,310.5C 5.33333,303.5 5.33333,296.5 6,289.5C 6.8138,284.196 9.64713,280.529 14.5,278.5 Z" />
                                                                            <path id="lr8" onclick="tooth_select(this)" style="opacity:0.954;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 348.5,278.5 C 358.839,278.334 369.172,278.5 379.5,279C 384.551,280.717 387.385,284.217 388,289.5C 389.042,299.635 388.375,309.635 386,319.5C 383.934,324.626 380.1,327.459 374.5,328C 362.618,329.264 350.951,328.264 339.5,325C 332.877,321.807 330.71,316.64 333,309.5C 334.661,301.894 335.994,294.227 337,286.5C 339.485,281.749 343.319,279.082 348.5,278.5 Z" />
                                                                        </g>

                                                                        <!-- Upright text labels -->
                                                                        <text id="tll1" onclick="tooth_select(document.getElementById('ll1'))" x="224.5" y="344.5" style="cursor:pointer;">1</text>
                                                                        <text id="tlr1" onclick="tooth_select(document.getElementById('lr1'))" x="174.5" y="344.5" style="cursor:pointer;">1</text>
                                                                        <text id="tll2" onclick="tooth_select(document.getElementById('ll2'))" x="260.5" y="328.5" style="cursor:pointer;">2</text>
                                                                        <text id="tlr2" onclick="tooth_select(document.getElementById('lr2'))" x="134.5" y="328.5" style="cursor:pointer;">2</text>
                                                                        <text id="tll3" onclick="tooth_select(document.getElementById('ll3'))" x="284.5" y="298.5" style="cursor:pointer;">3</text>
                                                                        <text id="tlr3" onclick="tooth_select(document.getElementById('lr3'))" x="110.5" y="298.5" style="cursor:pointer;">3</text>
                                                                        <text id="tll4" onclick="tooth_select(document.getElementById('ll4'))" x="310.5" y="260.5" style="cursor:pointer;">4</text>
                                                                        <text id="tlr4" onclick="tooth_select(document.getElementById('lr4'))" x="84.5" y="260.5" style="cursor:pointer;">4</text>
                                                                        <text id="tll5" onclick="tooth_select(document.getElementById('ll5'))" x="330.5" y="223.5" style="cursor:pointer;">5</text>
                                                                        <text id="tlr5" onclick="tooth_select(document.getElementById('lr5'))" x="64.5" y="223.5" style="cursor:pointer;">5</text>
                                                                        <text id="tll6" onclick="tooth_select(document.getElementById('ll6'))" x="344.5" y="180.5" style="cursor:pointer;">6</text>
                                                                        <text id="tlr6" onclick="tooth_select(document.getElementById('lr6'))" x="50.5" y="180.5" style="cursor:pointer;">6</text>
                                                                        <text id="tll7" onclick="tooth_select(document.getElementById('ll7'))" x="355.5" y="127.5" style="cursor:pointer;">7</text>
                                                                        <text id="tlr7" onclick="tooth_select(document.getElementById('lr7'))" x="39.5" y="127.5" style="cursor:pointer;">7</text>
                                                                        <text id="tll8" onclick="tooth_select(document.getElementById('ll8'))" x="365.5" y="71.5" style="cursor:pointer;">8</text>
                                                                        <text id="tlr8" onclick="tooth_select(document.getElementById('lr8'))" x="29.5" y="71.5" style="cursor:pointer;">8</text>
                                                                    </svg>
                                                                </div>
                                                                <div id="PrimaryDentition" class="d-none">
                                                                    <svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="237" height="161" style="z-index: 9999;shape-rendering:geometricPrecision; text-rendering:geometricPrecision; image-rendering:optimizeQuality; fill-rule:evenodd; clip-rule:evenodd" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 237 161">
                                                                        <style>
                                                                            text {
                                                                                font-family: Arial;
                                                                                font-size: 16px;
                                                                                font-weight: bold;
                                                                                fill: black;
                                                                                text-anchor: middle;
                                                                                dominant-baseline: middle;
                                                                            }
                                                                        </style>

                                                                        <g>
                                                                            <path id="cur1" onclick="tooth_select(this)" style="opacity:0.936;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 101.5,12.5 C 107.061,11.8024 112.227,12.8024 117,15.5C 117.692,24.0905 115.192,31.5905 109.5,38C 98.9657,37.8431 91.1324,33.0097 86,23.5C 85.0799,20.6917 85.9133,18.5251 88.5,17C 92.8335,15.181 97.1668,13.681 101.5,12.5 Z"/>
                                                                            <text id="tcur1" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="101" y="25">A</text>
                                                                        </g>

                                                                        <g>
                                                                            <path id="cul1" onclick="tooth_select(this)" style="opacity:0.936;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 123.5,12.5 C 130.327,12.1241 136.994,12.9574 143.5,15C 146.249,16.1227 148.749,17.6227 151,19.5C 151.667,20.8333 151.667,22.1667 151,23.5C 146.737,29.7647 141.237,34.598 134.5,38C 130.495,39.0981 126.995,38.2648 124,35.5C 120.613,29.2317 119.28,22.565 120,15.5C 121.145,14.3636 122.312,13.3636 123.5,12.5 Z"/>
                                                                            <text id="tcul1" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="135" y="25">A</text>
                                                                        </g>

                                                                        <g>
                                                                            <path id="cur2" onclick="tooth_select(this)" style="opacity:0.93;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 75.5,21.5 C 77.8568,21.3367 80.1902,21.5034 82.5,22C 87.1827,28.4194 88.6827,35.586 87,43.5C 86.1667,45.6667 84.6667,47.1667 82.5,48C 79.0717,48.7011 75.7383,48.3677 72.5,47C 67.6977,44.1927 63.531,40.6927 60,36.5C 58.8238,32.7399 59.9904,29.9066 63.5,28C 67.4339,25.5361 71.4339,23.3694 75.5,21.5 Z"/>
                                                                            <text id="tcur2" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="75" y="35">B</text>
                                                                        </g>

                                                                        <g>
                                                                            <path id="cul2" onclick="tooth_select(this)" style="opacity:0.93;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 154.5,21.5 C 163.565,22.1165 171.065,25.7831 177,32.5C 177.667,33.8333 177.667,35.1667 177,36.5C 172.457,41.1866 167.291,45.02 161.5,48C 156.269,49.7238 152.435,48.2238 150,43.5C 148.255,35.3554 149.755,28.0221 154.5,21.5 Z"/>
                                                                            <text id="tcul2" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="165" y="35">B</text>
                                                                        </g>

                                                                        <g>
                                                                            <path id="cur3" onclick="tooth_select(this)" style="opacity:0.941;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 53.5,41.5 C 66.1955,41.0255 71.6955,47.0255 70,59.5C 69.0794,64.2609 66.246,66.5942 61.5,66.5C 52.1421,65.2939 44.6421,60.9606 39,53.5C 38.3131,51.0797 38.8131,48.913 40.5,47C 44.7239,44.7065 49.0572,42.8731 53.5,41.5 Z"/>
                                                                            <text id="tcur3" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="55" y="55">C</text>
                                                                        </g>

                                                                        <g>
                                                                            <path id="cul3" onclick="tooth_select(this)" style="opacity:0.941;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 174.5,41.5 C 181.446,41.7364 188.113,43.2364 194.5,46C 197.29,48.2103 198.123,51.0437 197,54.5C 190.087,62.8758 181.253,66.7092 170.5,66C 168.959,64.4207 167.792,62.5873 167,60.5C 164.359,51.8685 166.859,45.5352 174.5,41.5 Z"/>
                                                                            <text id="tcul3" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="180" y="55">C</text>
                                                                        </g>

                                                                        <g>
                                                                            <path id="cur4" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 29.5,98.5 C 28.0697,97.4625 26.403,96.7959 24.5,96.5C 22.563,95.0686 20.7297,93.4019 19,91.5C 18.3333,89.1667 18.3333,86.8333 19,84.5C 22.5766,78.1077 25.5766,71.4411 28,64.5C 29.8333,62.6667 31.6667,60.8333 33.5,59C 35.5,58.3333 37.5,58.3333 39.5,59C 44.6037,61.7734 49.437,64.9401 54,68.5C 56.4839,80.0585 53.3172,89.8919 44.5,98C 39.5806,99.7781 34.5806,99.9448 29.5,98.5 Z"/>
                                                                            <text id="tcur4" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="35" y="85">D</text>
                                                                        </g>

                                                                        <g>
                                                                            <path id="cul4" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 196.5,58.5 C 201.347,57.8404 205.181,59.5071 208,63.5C 211.397,71.7846 214.897,79.9513 218.5,88C 218.481,91.0334 217.148,93.3667 214.5,95C 207.87,98.4089 200.87,99.7422 193.5,99C 184.829,91.4893 180.662,81.9893 181,70.5C 185.784,65.8752 190.951,61.8752 196.5,58.5 Z"/>
                                                                            <text id="tcul4" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="200" y="75">D</text>
                                                                        </g>

                                                                        <g>
                                                                            <path id="cur5" onclick="tooth_select(this)" style="opacity:0.945;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 16.5,98.5 C 20.5483,98.3946 24.5483,98.7279 28.5,99.5C 32.6546,100.099 36.6546,101.265 40.5,103C 42.0412,104.579 43.2078,106.413 44,108.5C 42.4797,117.737 42.1464,127.07 43,136.5C 41.1667,141 38,144.167 33.5,146C 22.8381,148.532 13.6715,146.032 6,138.5C 4.94295,135.793 4.44295,132.96 4.5,130C 6.37616,122.313 7.54283,114.479 8,106.5C 9.44748,102.215 12.2808,99.5484 16.5,98.5 Z"/>
                                                                            <text id="tcur5" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="20" y="120">E</text>
                                                                        </g>

                                                                        <g>
                                                                            <path id="cul5" onclick="tooth_select(this)" style="opacity:0.945;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 214.5,97.5 C 220.957,96.9749 225.457,99.6416 228,105.5C 229.043,112.213 230.377,118.88 232,125.5C 233.968,138.209 228.468,145.042 215.5,146C 197.04,147.979 190.04,139.813 194.5,121.5C 190.959,114.151 191.959,107.651 197.5,102C 203.343,100.673 209.01,99.1727 214.5,97.5 Z"/>
                                                                            <text id="tcul5" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="215" y="120">E</text>
                                                                        </g>
                                                                    </svg>
                                                                    <br>
                                                                    <svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="237" height="161" style="margin-top: -20px;shape-rendering:geometricPrecision; text-rendering:geometricPrecision; image-rendering:optimizeQuality; fill-rule:evenodd; clip-rule:evenodd" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 237 161">
                                                                        <style>
                                                                            text {
                                                                                font-family: Arial;
                                                                                font-size: 16px;
                                                                                font-weight: bold;
                                                                                fill: black;
                                                                                text-anchor: middle;
                                                                                dominant-baseline: middle;
                                                                            }
                                                                        </style>

                                                                        <!-- Rotated teeth paths -->
                                                                        <g transform="rotate(180 118.5 80.5)">
                                                                            <path id="cll1" onclick="tooth_select(this)" style="opacity:0.936;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 101.5,12.5 C 107.061,11.8024 112.227,12.8024 117,15.5C 117.692,24.0905 115.192,31.5905 109.5,38C 98.9657,37.8431 91.1324,33.0097 86,23.5C 85.0799,20.6917 85.9133,18.5251 88.5,17C 92.8335,15.181 97.1668,13.681 101.5,12.5 Z"/>
                                                                            <path id="clr1" onclick="tooth_select(this)" style="opacity:0.936;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 123.5,12.5 C 130.327,12.1241 136.994,12.9574 143.5,15C 146.249,16.1227 148.749,17.6227 151,19.5C 151.667,20.8333 151.667,22.1667 151,23.5C 146.737,29.7647 141.237,34.598 134.5,38C 130.495,39.0981 126.995,38.2648 124,35.5C 120.613,29.2317 119.28,22.565 120,15.5C 121.145,14.3636 122.312,13.3636 123.5,12.5 Z"/>
                                                                            <path id="cll2" onclick="tooth_select(this)" style="opacity:0.93;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 75.5,21.5 C 77.8568,21.3367 80.1902,21.5034 82.5,22C 87.1827,28.4194 88.6827,35.586 87,43.5C 86.1667,45.6667 84.6667,47.1667 82.5,48C 79.0717,48.7011 75.7383,48.3677 72.5,47C 67.6977,44.1927 63.531,40.6927 60,36.5C 58.8238,32.7399 59.9904,29.9066 63.5,28C 67.4339,25.5361 71.4339,23.3694 75.5,21.5 Z"/>
                                                                            <path id="clr2" onclick="tooth_select(this)" style="opacity:0.93;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 154.5,21.5 C 163.565,22.1165 171.065,25.7831 177,32.5C 177.667,33.8333 177.667,35.1667 177,36.5C 172.457,41.1866 167.291,45.02 161.5,48C 156.269,49.7238 152.435,48.2238 150,43.5C 148.255,35.3554 149.755,28.0221 154.5,21.5 Z"/>
                                                                            <path id="cll3" onclick="tooth_select(this)" style="opacity:0.941;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 53.5,41.5 C 66.1955,41.0255 71.6955,47.0255 70,59.5C 69.0794,64.2609 66.246,66.5942 61.5,66.5C 52.1421,65.2939 44.6421,60.9606 39,53.5C 38.3131,51.0797 38.8131,48.913 40.5,47C 44.7239,44.7065 49.0572,42.8731 53.5,41.5 Z"/>
                                                                            <path id="clr3" onclick="tooth_select(this)" style="opacity:0.941;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 174.5,41.5 C 181.446,41.7364 188.113,43.2364 194.5,46C 197.29,48.2103 198.123,51.0437 197,54.5C 190.087,62.8758 181.253,66.7092 170.5,66C 168.959,64.4207 167.792,62.5873 167,60.5C 164.359,51.8685 166.859,45.5352 174.5,41.5 Z"/>
                                                                            <path id="cll4" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 29.5,98.5 C 28.0697,97.4625 26.403,96.7959 24.5,96.5C 22.563,95.0686 20.7297,93.4019 19,91.5C 18.3333,89.1667 18.3333,86.8333 19,84.5C 22.5766,78.1077 25.5766,71.4411 28,64.5C 29.8333,62.6667 31.6667,60.8333 33.5,59C 35.5,58.3333 37.5,58.3333 39.5,59C 44.6037,61.7734 49.437,64.9401 54,68.5C 56.4839,80.0585 53.3172,89.8919 44.5,98C 39.5806,99.7781 34.5806,99.9448 29.5,98.5 Z"/>
                                                                            <path id="clr4" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 196.5,58.5 C 201.347,57.8404 205.181,59.5071 208,63.5C 211.397,71.7846 214.897,79.9513 218.5,88C 218.481,91.0334 217.148,93.3667 214.5,95C 207.87,98.4089 200.87,99.7422 193.5,99C 184.829,91.4893 180.662,81.9893 181,70.5C 185.784,65.8752 190.951,61.8752 196.5,58.5 Z"/>
                                                                            <path id="cll5" onclick="tooth_select(this)" style="opacity:0.945;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 16.5,98.5 C 20.5483,98.3946 24.5483,98.7279 28.5,99.5C 32.6546,100.099 36.6546,101.265 40.5,103C 42.0412,104.579 43.2078,106.413 44,108.5C 42.4797,117.737 42.1464,127.07 43,136.5C 41.1667,141 38,144.167 33.5,146C 22.8381,148.532 13.6715,146.032 6,138.5C 4.94295,135.793 4.44295,132.96 4.5,130C 6.37616,122.313 7.54283,114.479 8,106.5C 9.44748,102.215 12.2808,99.5484 16.5,98.5 Z"/>
                                                                            <path id="clr5" onclick="tooth_select(this)" style="opacity:0.945;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 214.5,97.5 C 220.957,96.9749 225.457,99.6416 228,105.5C 229.043,112.213 230.377,118.88 232,125.5C 233.968,138.209 228.468,145.042 215.5,146C 197.04,147.979 190.04,139.813 194.5,121.5C 190.959,114.151 191.959,107.651 197.5,102C 203.343,100.673 209.01,99.1727 214.5,97.5 Z"/>
                                                                        </g>

                                                                        <!-- Upright text labels -->
                                                                        <text id="tcll1" onclick="tooth_select(document.getElementById('cll1'))" x="135" y="140" style="cursor:pointer;">A</text>
                                                                        <text id="tclr1" onclick="tooth_select(document.getElementById('clr1'))" x="101" y="140" style="cursor:pointer;">A</text>
                                                                        <text id="tcll2" onclick="tooth_select(document.getElementById('cll2'))" x="165" y="130" style="cursor:pointer;">B</text>
                                                                        <text id="tclr2" onclick="tooth_select(document.getElementById('clr2'))" x="75" y="130" style="cursor:pointer;">B</text>
                                                                        <text id="tcll3" onclick="tooth_select(document.getElementById('cll3'))" x="180" y="110" style="cursor:pointer;">C</text>
                                                                        <text id="tclr3" onclick="tooth_select(document.getElementById('clr3'))" x="55" y="110" style="cursor:pointer;">C</text>
                                                                        <text id="tcll4" onclick="tooth_select(document.getElementById('cll4'))" x="200" y="80" style="cursor:pointer;">D</text>
                                                                        <text id="tclr4" onclick="tooth_select(document.getElementById('clr4'))" x="35" y="80" style="cursor:pointer;">D</text>
                                                                        <text id="tcll5" onclick="tooth_select(document.getElementById('cll5'))" x="215" y="40" style="cursor:pointer;">E</text>
                                                                        <text id="tclr5" onclick="tooth_select(document.getElementById('clr5'))" x="20" y="40" style="cursor:pointer;">E</text>
                                                                    </svg>
                                                                </div>
                                                            </div>
                                                            <script>
                                                                let selected_jaw = "";
                                                                function select_jaw(btn,jaw){
                                                                    selected_teeth_5 = [];
                                                                    if(btn.classList.contains('btn-primary')){
                                                                        //BARAYE IN K DANDUNAYE ENTEKHABI RESET BESHAN
                                                                        btn.classList.add('btn-outline-primary');
                                                                        btn.classList.remove('btn-primary');

                                                                        if(document.getElementById('slctJawUBTN').classList.contains('btn-outline-primary') && document.getElementById('slctJawLBTN').classList.contains('btn-outline-primary')){
                                                                            document.getElementById('SelectedJawText').style.display = "none";
                                                                            document.getElementById('dentChartSecondary').style.display = "none";
                                                                            document.getElementById('dentChartPrimary').style.display = "none";

                                                                            document.getElementById('SelectedJawText').innerHTML = "";
                                                                            document.getElementById('add-treatment-plan-message').classList.remove('d-none');
                                                                            document.getElementById('add-treatment-plan-box').classList.add('d-none');
                                                                        }
                                                                        else {
                                                                            if(document.getElementById('slctJawUBTN').classList.contains('btn-primary')){
                                                                                selected_teeth_5 = ["UPPERJAW"];
                                                                                document.getElementById('SelectedJawText').innerHTML = "کل فک بالا";
                                                                            }
                                                                            else {
                                                                                if(document.getElementById('slctJawLBTN').classList.contains('btn-primary')){
                                                                                    selected_teeth_5 = ["LOWERJAW"];
                                                                                    document.getElementById('SelectedJawText').innerHTML = "کل فک پایین";
                                                                                }
                                                                            }
                                                                        }

                                                                    }
                                                                    else {
                                                                        //BARAYE IN K DANDUNAYE ENTEKHABI RESET BESHAN

                                                                        ur = "";
                                                                        ul = "";
                                                                        lr = "";
                                                                        ll = "";

                                                                        cur = "";
                                                                        cul = "";
                                                                        clr = "";
                                                                        cll = "";

                                                                        document.getElementById('dentChartUpLeft').innerHTML = ul;
                                                                        document.getElementById('dentChartUpRight').innerHTML = ur;
                                                                        document.getElementById('dentChartLowLeft').innerHTML = ll;
                                                                        document.getElementById('dentChartLowRight').innerHTML = lr;

                                                                        document.getElementById('dentChartChildUpLeft').innerHTML = cul;
                                                                        document.getElementById('dentChartChildUpRight').innerHTML = cur;
                                                                        document.getElementById('dentChartChildLowLeft').innerHTML = cll;
                                                                        document.getElementById('dentChartChildLowRight').innerHTML = clr;

                                                                        var tmp45 = document.getElementsByTagName('path');
                                                                        for (const tmp45Element of tmp45) {
                                                                            $(tmp45Element).attr('fill','#ffffff');
                                                                            $(tmp45Element).attr('stroke','#000000');
                                                                            $('#t' + tmp45Element.id).css('fill','#000000');
                                                                        }
                                                                        document.getElementById('add-treatment-plan-message').classList.remove('d-none');
                                                                        document.getElementById('add-treatment-plan-box').classList.add('d-none');

                                                                        btn.classList.remove('btn-outline-primary');
                                                                        btn.classList.add('btn-primary');

                                                                        document.getElementById('SelectedJawText').style.display = "block";
                                                                        document.getElementById('dentChartSecondary').style.display = "none";
                                                                        document.getElementById('dentChartPrimary').style.display = "none";
                                                                        selected_teeth_5 = ["BOTHJAWS"];
                                                                        document.getElementById('SelectedJawText').innerHTML = "فک بالا و فک پایین";
                                                                        if(jaw === "u" && document.getElementById('slctJawLBTN').classList.contains('btn-outline-primary')){
                                                                            selected_teeth_5 = ["UPPERJAW"];
                                                                            document.getElementById('SelectedJawText').innerHTML = "کل فک بالا";
                                                                        }
                                                                        else{
                                                                            if(document.getElementById('slctJawUBTN').classList.contains('btn-outline-primary')){
                                                                                selected_teeth_5 = ["LOWERJAW"];
                                                                                document.getElementById('SelectedJawText').innerHTML = "کل فک پایین";
                                                                            }
                                                                        }
                                                                        document.getElementById('add-treatment-plan-message').classList.add('d-none');
                                                                        document.getElementById('add-treatment-plan-box').classList.remove('d-none');
                                                                    }
                                                                    document.getElementById('selected_teeth_hidden').value = JSON.stringify(selected_teeth_5);
                                                                    document.getElementById('selected_dentition_hidden').value = selected_dentition;
                                                                }
                                                                function change_dentition(btn){
                                                                    if(selected_dentition === "SECONDARY"){
                                                                        document.getElementById('PrimaryDentition').classList.remove('d-none');
                                                                        document.getElementById('SecondaryDentition').classList.add('d-none');
                                                                        document.getElementById('secondarybtn').classList.remove('btn-primary');
                                                                        document.getElementById('primarybtn').classList.add('btn-primary');
                                                                        selected_dentition = "PRIMARY";
                                                                    }
                                                                    else {
                                                                        document.getElementById('PrimaryDentition').classList.add('d-none');
                                                                        document.getElementById('SecondaryDentition').classList.remove('d-none');
                                                                        document.getElementById('secondarybtn').classList.add('btn-primary');
                                                                        document.getElementById('primarybtn').classList.remove('btn-primary');
                                                                        selected_dentition = "SECONDARY";
                                                                    }
                                                                    document.getElementById('selected_teeth_hidden').value = JSON.stringify(selected_teeth_5);
                                                                    document.getElementById('selected_dentition_hidden').value = selected_dentition;
                                                                }
                                                                function sort_dental_chart(text) {
                                                                    return text.split('').sort().join('');
                                                                }
                                                                function sort_dental_chart_reverse(text) {
                                                                    return text.split('').sort().reverse().join('');
                                                                }
                                                                var ur = "";
                                                                var ul = "";
                                                                var lr = "";
                                                                var ll = "";

                                                                var cur = "";
                                                                var cul = "";
                                                                var clr = "";
                                                                var cll = "";
                                                                var selected_teeth_5 = [];
                                                                var selected_dentition = "SECONDARY";
                                                                function tooth_select(tooth){
                                                                    document.getElementById('SelectedJawText').style.display = "none";
                                                                    document.getElementById('dentChartPrimary').style.display = "block";
                                                                    document.getElementById('dentChartSecondary').style.display = "block";
                                                                    document.getElementById('slctJawUBTN').classList.add('btn-outline-primary');
                                                                    document.getElementById('slctJawUBTN').classList.remove('btn-primary');
                                                                    document.getElementById('slctJawLBTN').classList.add('btn-outline-primary');
                                                                    document.getElementById('slctJawLBTN').classList.remove('btn-primary');

                                                                    if($(tooth).attr('fill') === "#ffffff"){
                                                                        $(tooth).attr('fill','#6236FF');
                                                                        $(tooth).attr('stroke','#6236FF');
                                                                        $('#t' + tooth.id).css('fill','#ffffff');
                                                                        //secondary dentition
                                                                        if(tooth.id[0] + tooth.id[1] === "ur"){
                                                                            ur += tooth.id[2];
                                                                        }
                                                                        if(tooth.id[0] + tooth.id[1] === "ul"){
                                                                            ul += tooth.id[2];
                                                                        }
                                                                        if(tooth.id[0] + tooth.id[1] === "lr"){
                                                                            lr += tooth.id[2];
                                                                        }
                                                                        if(tooth.id[0] + tooth.id[1] === "ll"){
                                                                            ll += tooth.id[2];
                                                                        }
                                                                        //primary dentition
                                                                        if(tooth.id[1] + tooth.id[2] === "ur"){
                                                                            cur += tooth.id[3];
                                                                        }
                                                                        if(tooth.id[1] + tooth.id[2] === "ul"){
                                                                            cul += tooth.id[3];
                                                                        }
                                                                        if(tooth.id[1] + tooth.id[2] === "lr"){
                                                                            clr += tooth.id[3];
                                                                        }
                                                                        if(tooth.id[1] + tooth.id[2] === "ll"){
                                                                            cll += tooth.id[3];
                                                                        }
                                                                    }
                                                                    else {
                                                                        $(tooth).attr('fill','#ffffff');
                                                                        $(tooth).attr('stroke','#000000');
                                                                        $('#t' + tooth.id).css('fill','#000000');

                                                                        //secondary dentition
                                                                        if(tooth.id[0] + tooth.id[1] === "ur"){
                                                                            ur = ur.replace(tooth.id[2],'');
                                                                        }
                                                                        if(tooth.id[0] + tooth.id[1] === "ul"){
                                                                            ul = ul.replace(tooth.id[2],'');
                                                                        }
                                                                        if(tooth.id[0] + tooth.id[1] === "lr"){
                                                                            lr = lr.replace(tooth.id[2],'');
                                                                        }
                                                                        if(tooth.id[0] + tooth.id[1] === "ll"){
                                                                            ll = ll.replace(tooth.id[2],'');
                                                                        }
                                                                        //primary dentition
                                                                        if(tooth.id[1] + tooth.id[2] === "ur"){
                                                                            cur = cur.replace(tooth.id[3],'');
                                                                        }
                                                                        if(tooth.id[1] + tooth.id[2] === "ul"){
                                                                            cul = cul.replace(tooth.id[3],'');
                                                                        }
                                                                        if(tooth.id[1] + tooth.id[2] === "lr"){
                                                                            clr = clr.replace(tooth.id[3],'');
                                                                        }
                                                                        if(tooth.id[1] + tooth.id[2] === "ll"){
                                                                            cll = cll.replace(tooth.id[3],'');
                                                                        }
                                                                    }
                                                                    ur = sort_dental_chart_reverse(ur);
                                                                    ul = sort_dental_chart(ul);
                                                                    lr = sort_dental_chart_reverse(lr);
                                                                    ll = sort_dental_chart(ll);

                                                                    cur = sort_dental_chart_reverse(cur);
                                                                    cul = sort_dental_chart(cul);
                                                                    clr = sort_dental_chart_reverse(clr);
                                                                    cll = sort_dental_chart(cll);

                                                                    document.getElementById('dentChartUpLeft').innerHTML = ul;
                                                                    document.getElementById('dentChartUpRight').innerHTML = ur;
                                                                    document.getElementById('dentChartLowLeft').innerHTML = ll;
                                                                    document.getElementById('dentChartLowRight').innerHTML = lr;

                                                                    function change_child_teeth_to_ABCD(text){
                                                                        text = text.replace('1','A');
                                                                        text = text.replace('2','B');
                                                                        text = text.replace('3','C');
                                                                        text = text.replace('4','D');
                                                                        text = text.replace('5','E');
                                                                        return text;
                                                                    }
                                                                    document.getElementById('dentChartChildUpLeft').innerHTML = change_child_teeth_to_ABCD(cul);
                                                                    document.getElementById('dentChartChildUpRight').innerHTML = change_child_teeth_to_ABCD(cur);
                                                                    document.getElementById('dentChartChildLowLeft').innerHTML = change_child_teeth_to_ABCD(cll);
                                                                    document.getElementById('dentChartChildLowRight').innerHTML = change_child_teeth_to_ABCD(clr);

                                                                    var arr_ur = ur.split('');
                                                                    var arr_ul = ul.split('');
                                                                    var arr_lr = lr.split('');
                                                                    var arr_ll = ll.split('');

                                                                    var arr_cur = cur.split('');
                                                                    var arr_cul = cul.split('');
                                                                    var arr_clr = clr.split('');
                                                                    var arr_cll = cll.split('');
                                                                    selected_teeth_5 = [];

                                                                    for (const string of arr_ur) {
                                                                        selected_teeth_5.push('ur' + string);
                                                                    }
                                                                    for (const string of arr_ul) {
                                                                        selected_teeth_5.push('ul' + string);
                                                                    }
                                                                    for (const string of arr_lr) {
                                                                        selected_teeth_5.push('lr' + string);
                                                                    }
                                                                    for (const string of arr_ll) {
                                                                        selected_teeth_5.push('ll' + string);
                                                                    }

                                                                    for (const string of arr_cur) {
                                                                        selected_teeth_5.push('cur' + string);
                                                                    }
                                                                    for (const string of arr_cul) {
                                                                        selected_teeth_5.push('cul' + string);
                                                                    }
                                                                    for (const string of arr_clr) {
                                                                        selected_teeth_5.push('clr' + string);
                                                                    }
                                                                    for (const string of arr_cll) {
                                                                        selected_teeth_5.push('cll' + string);
                                                                    }
                                                                    if(ul === "" && ur === "" && ll === "" && lr === "" && cul === "" && cur === "" && cll === "" && clr === ""){
                                                                        document.getElementById('add-treatment-plan-message').classList.remove('d-none');
                                                                        document.getElementById('add-treatment-plan-box').classList.add('d-none');
                                                                    }
                                                                    else {
                                                                        if(ul !== "" || ur !== "" || ll !== "" || lr !== ""){
                                                                            document.getElementById('dentChartSecondary').style.display = 'block';
                                                                        }
                                                                        else {
                                                                            document.getElementById('dentChartSecondary').style.display = 'none';
                                                                        }
                                                                        if(cul !== "" || cur !== "" || cll !== "" || clr !== ""){
                                                                            document.getElementById('dentChartPrimary').style.display = 'block';
                                                                        }
                                                                        else {
                                                                            document.getElementById('dentChartPrimary').style.display = 'none';
                                                                        }
                                                                        document.getElementById('add-treatment-plan-message').classList.add('d-none');
                                                                        document.getElementById('add-treatment-plan-box').classList.remove('d-none');
                                                                    }
                                                                    document.getElementById('selected_teeth_hidden').value = JSON.stringify(selected_teeth_5);
                                                                    document.getElementById('selected_dentition_hidden').value = selected_dentition;
                                                                }
                                                            </script>
                                                            <style>
                                                                .rotate90 {
                                                                    -webkit-transform: rotate(180deg);
                                                                    -moz-transform: rotate(180deg);
                                                                    -o-transform: rotate(180deg);
                                                                    -ms-transform: rotate(180deg);
                                                                    transform: rotate(180deg);
                                                                }
                                                            </style>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-6 col-lg-8">
                                                <div class="row g-3">
                                                    <div class="col-md-6">
                                                        <label class="form-label">انتخاب لابراتوار*</label>
                                                        <select name="lab_code" id="lab_code_select" class="form-select" onchange="lab_code_change(this);" required>
                                                            <option value="">انتخاب کنید</option>
                                                            <?php foreach ($labs as $lab): ?>
                                                                <option value="<?= htmlspecialchars($lab['lab_code']) ?>">
                                                                    <?= htmlspecialchars($lab['lab_name_encrypted']) ?>
                                                                </option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <label class="form-label">نوع سرویس*</label>
                                                        <select name="service_code" id="services_select" class="form-select" onchange="update_custom_fields(this.value)" required>
                                                            <option value="">انتخاب کنید</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="row g-3 mt-3">
                                                    <div class="col-md-6">
                                                        <label class="form-label" for="flatpickr-date">تاریخ ارسال</label>
                                                        <input class="form-control" name="send-date" id="flatpickr-date" placeholder="YYYY-MM-DD" type="text"/>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <label class="form-label">فایل ضمیمه</label>
                                                        <input type="file" id="upload_file" oninput="" name="uploaded_file[]" class="form-control" multiple>
                                                        <div id="uploaded_files_box">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div aria-hidden="true" class="modal fade" id="modalCenter" tabindex="-1" data-bs-backdrop="static">
                                                    <div class="modal-dialog modal-dialog-centered" role="document">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 class="modal-title" id="modalCenterTitle">آپلود فایل</h5>
                                                            </div>
                                                            <div class="modal-body">
                                                                <div class="row">
                                                                    <div class="col mb-3 text-center">
                                                                        <h2 class="form-label" for="nameWithTitle">در حال آپلود فایل ...</h2>
                                                                        <div class="progress mt-3">
                                                                            <div id="uploadProgress"
                                                                                 class="progress-bar progress-bar-striped progress-bar-animated bg-primary"
                                                                                 role="progressbar"
                                                                                 aria-valuemin="0"
                                                                                 aria-valuemax="100"
                                                                                 aria-valuenow="0"
                                                                                 style="width: 20%">
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row g-3 mt-2">
                                                    <div class="col-12">
                                                        <label class="form-label">دندان های انتخاب شده</label>
                                                        <h6 id="add-treatment-plan-message">لطفا در ابتدا یک یا چند دندان را انتخاب نمایید</h6>
                                                        <div id="add-treatment-plan-box" class="d-none">
                                                            <div class="row p-3">
                                                                <div class="col-12">
                                                                    <div class="row">
                                                                        <div id="dentChartSecondary" class="col-6 col-md-6 ">
                                                                            <h6>دندان های دائمی</h6>
                                                                            <table class="mt-3 mb-3">
                                                                                <tr>
                                                                                    <td id="dentChartUpLeft" style="border-bottom: 2px solid #000000;padding: 12px;width: 50%;text-align: center;letter-spacing: 8px;height: 50px;font-weight: bold;color: #000000;"></td id="dentChartLeft">
                                                                                    <td id="dentChartUpRight" style="border-bottom: 2px solid #000000;border-right: 2px solid #000000;padding: 12px;width: 50%;text-align: center;letter-spacing: 8px;font-weight: bold;color: #000000;"></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td id="dentChartLowLeft" style="border-top: 2px solid #000000;padding: 12px;width: 50%;text-align: center;letter-spacing: 8px;height: 50px;font-weight: bold;color: #000000;"></td>
                                                                                    <td id="dentChartLowRight" style="border-top: 2px solid #000000;border-right: 2px solid #000000;padding: 12px;width: 50%;text-align: center;letter-spacing: 8px;font-weight: bold;color: #000000;"></td>
                                                                                </tr>
                                                                            </table>
                                                                        </div>
                                                                        <div id="dentChartPrimary" class="col-6 col-md-6 ">
                                                                            <h6>دندان های شیری</h6>
                                                                            <table class="mt-3 mb-3">
                                                                                <tr>
                                                                                    <td id="dentChartChildUpLeft" style="border-bottom: 2px solid #000000;padding: 12px;width: 50%;text-align: center;letter-spacing: 8px;height: 50px;font-weight: bold;color: #000000;"></td id="dentChartLeft">
                                                                                    <td id="dentChartChildUpRight" style="border-bottom: 2px solid #000000;border-right: 2px solid #000000;padding: 12px;width: 50%;text-align: center;letter-spacing: 8px;font-weight: bold;color: #000000;"></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td id="dentChartChildLowLeft" style="border-top: 2px solid #000000;padding: 12px;width: 50%;text-align: center;letter-spacing: 8px;height: 50px;font-weight: bold;color: #000000;"></td>
                                                                                    <td id="dentChartChildLowRight" style="border-top: 2px solid #000000;border-right: 2px solid #000000;padding: 12px;width: 50%;text-align: center;letter-spacing: 8px;font-weight: bold;color: #000000;"></td>
                                                                                </tr>
                                                                            </table>
                                                                        </div>

                                                                    </div>
                                                                    <h6 id="SelectedJawText" class="mt-3 mb-3">فک بالا</h6>
                                                                </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row g-3 mt-3">
                                                    <div class="col-12">
                                                        <label class="form-label">توضیحات سفارش</label>
                                                        <textarea name="order_note" class="form-control" rows="4" placeholder="توضیحات تکمیلی در مورد سفارش را وارد کنید..."></textarea>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <hr class="my-4 mx-n4" />

                                        <!-- Step 4: Custom Fields -->
                                        <div class="row" id="custom_fields_section" style="display: none;">
                                            <div class="col-12">
                                                <h6 class="fw-medium">فرم</h6>
                                            </div>
                                            <div class="row" id="custom_fields">
                                            </div>
                                        </div>
                                        <!-- Hidden fields -->
                                        <input type="hidden" name="clinic_code" value="<?= htmlspecialchars($office_code) ?>">
                                        <input type="hidden" id="add-file-codes" name="add-file-codes" value='[]'>
                                        <input type="hidden" name="selected_teeth" id="selected_teeth_hidden">
                                        <input type="hidden" name="selected_dentition" id="selected_dentition_hidden" value="PRIMARY">

                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- / Content -->

                <!-- Footer -->
                <footer class="content-footer footer bg-footer-theme">
                    <div class="container-xxl">
                        <div class="footer-container d-flex align-items-center justify-content-between py-2 flex-md-row flex-column">
                            <div>
                                ©
                                <script>
                                    document.write(new Date().getFullYear());
                                </script>
                                ، ارائه شده توسط
                                <a href="#" target="_blank" class="footer-link text-primary fw-medium">بایت‌مستر</a>
                                در سایت
                                <a href="#" target="_blank" class="footer-link text-primary fw-medium">راستچین</a>
                            </div>
                            <div class="d-none d-lg-inline-block">
                                <a href="#" class="footer-link me-4" target="_blank">لایسنس</a>
                                <a href="#" target="_blank" class="footer-link me-4">قالب‌های بیشتر</a>
                                <a href="#" target="_blank" class="footer-link me-4">مستندات</a>
                                <a href="#" target="_blank" class="footer-link">پشتیبانی</a>
                            </div>
                        </div>
                    </div>
                </footer>
                <!-- / Footer -->

                <div class="content-backdrop fade"></div>
            </div>
            <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
    </div>

    <!-- Overlay -->
    <div class="layout-overlay layout-menu-toggle"></div>

    <!-- Drag Target Area To SlideIn Menu On Small Screens -->
    <div class="drag-target"></div>
</div>
<!-- / Layout wrapper -->

<!-- Core JS -->
<!-- build:js assets/vendor/js/core.js -->
<script src="../../assets/vendor/libs/jquery/jquery.js"></script>
<script src="../../assets/vendor/libs/popper/popper.js"></script>
<script src="../../assets/vendor/js/bootstrap.js"></script>
<script src="../../assets/vendor/libs/node-waves/node-waves.js"></script>
<script src="../../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="../../assets/vendor/libs/hammer/hammer.js"></script>
<script src="../../assets/vendor/libs/i18n/i18n.js"></script>
<script src="../../assets/vendor/libs/typeahead-js/typeahead.js"></script>
<script src="../../assets/vendor/js/menu.js"></script>

<!-- endbuild -->

<!-- Vendors JS -->
<script src="../../assets/vendor/libs/select2/select2.js"></script>
<script src="../../assets/vendor/libs/tagify/tagify.js"></script>
<script src="../../assets/vendor/libs/bootstrap-select/bootstrap-select.js"></script>
<script src="../../assets/vendor/libs/typeahead-js/typeahead.js"></script>
<script src="../../assets/vendor/libs/moment/moment.js"></script>
<script src="../../assets/libs/jdate/jdate.js"></script>
<script src="../../assets/libs/flatpickr/flatpickr-jalali.js"></script>
<script src="../../assets/libs/flatpickr/l10n/fa.js"></script>
<script src="../../assets/libs/jalali-datepicker/jalalidatepicker.js"></script>
<script src="../../assets/libs/bootstrap-datepicker/bootstrap-datepicker-jdate.js"></script>
<script src="../../assets/libs/bootstrap-datepicker/bootstrap-datepicker.js"></script>
<script src="../../assets/libs/bootstrap-daterangepicker/bootstrap-daterangepicker-jdate.js"></script>
<script src="../../assets/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"></script>
<script src="../../assets/vendor/libs/jquery-timepicker/jquery-timepicker.js"></script>
<script src="../../assets/vendor/libs/pickr/pickr.js"></script>
<!-- Main JS -->
<script src="../../assets/js/main.js"></script>

<!-- Page JS -->
<script src="../../assets/js/forms-pickers-jalali.js"></script>

<script>
    $(document).ready(function() {
        // Initialize Select2 for better dropdown experience
        $('.form-select').select2({
            placeholder: 'انتخاب کنید',
            allowClear: true
        });

        // Patient selection toggle
        $('input[name="patient_selection_type"]').on('change', function() {
            const selectedType = $(this).val();
            console.log(selectedType);
            if (selectedType === 'existing') {
                $('#existing_patient_container').show();
                $('#manual_patient_container').hide();
                $('#patient_select').prop('required', true);
                $('#manual_patient_input').prop('required', false);
                $('#manual_patient_input').val(''); // Clear manual input
            } else {
                $('#existing_patient_container').hide();
                $('#manual_patient_container').show();
                $('#patient_select').prop('required', false);
                $('#manual_patient_input').prop('required', true);
                $('#patient_select').val(''); // Clear dropdown selection
            }
        });

        // Dentist selection toggle
        $('input[name="dentist_selection_type"]').on('change', function() {
            const selectedType = $(this).val();

            if (selectedType === 'existing') {
                $('#existing_dentist_container').show();
                $('#manual_dentist_container').hide();
                $('#dentist_select').prop('required', true);
                $('#manual_dentist_input').prop('required', false);
                $('#manual_dentist_input').val(''); // Clear manual input
            } else {
                $('#existing_dentist_container').hide();
                $('#manual_dentist_container').show();
                $('#dentist_select').prop('required', false);
                $('#manual_dentist_input').prop('required', true);
                $('#dentist_select').val(''); // Clear dropdown selection
            }
        });

        // Update form validation to handle both scenarios
        $('#orderForm').on('submit', function(e) {
            let isValid = true;

            // Patient validation
            const patientType = $('input[name="patient_selection_type"]:checked').val();
            if (patientType === 'existing') {
                if (!$('#patient_select').val()) {
                    isValid = false;
                    $('#patient_select').addClass('is-invalid');
                }
            } else {
                if (!$('#manual_patient_input').val().trim()) {
                    isValid = false;
                    $('#manual_patient_input').addClass('is-invalid');
                }
            }

            // Dentist validation
            const dentistType = $('input[name="dentist_selection_type"]:checked').val();
            if (dentistType === 'existing') {
                if (!$('#dentist_select').val()) {
                    isValid = false;
                    $('#dentist_select').addClass('is-invalid');
                }
            } else {
                if (!$('#manual_dentist_input').val().trim()) {
                    isValid = false;
                    $('#manual_dentist_input').addClass('is-invalid');
                }
            }
            if($('#selected_dentition_hidden').val() !== "PRIMARY" && $('#selected_dentition_hidden').val() !== "SECONDARY"){
                e.preventDefault();
                alert('دنتیشن دندانی (شیری یا دائمی) مشخص نشده.');
            }
            if($('#selected_teeth_hidden').val() === "" || $('#selected_teeth_hidden').val() === "[]"){
                e.preventDefault();
                alert('دندان یا فک مشخص نشده است.');
            }
            // Check other required fields
            $('input[required]:visible, select[required]:visible').each(function() {
                if (!$(this).val()) {
                    isValid = false;
                    $(this).addClass('is-invalid');
                } else {
                    $(this).removeClass('is-invalid');
                }
            });

            if (!isValid) {
                e.preventDefault();
                alert('لطفاً تمام فیلدهای ضروری را پر کنید.');
            }
        });

        // Remove validation errors on input
        $('input, select').on('change input', function() {
            $(this).removeClass('is-invalid');
        });
    });
</script>
<script>
    function update_custom_fields(select){
        console.log(custom_fields);
        console.log(select);
        const fields_box = document.getElementById('custom_fields');
        fields_box.innerHTML = "";
        for (const custom_field of custom_fields) {
            let fieldHtml = '';
            if(custom_field.cf_service_code === select){
                let required = '';
                let star = '';
                if(custom_field.cf_required === 1){
                    required = 'required';
                    star = '*';
                }
                if(custom_field.cf_type === "text"){
                    fieldHtml = `
                    <div class="col-md-6 custom-field-container" data-service="${custom_field.cf_service_code}">
                        <label class="form-label">${custom_field.cf_title}${star}</label>
                        <input type="text"
                               name="custom_field_${custom_field.cf_code}"
                               class="form-control"
                               placeholder="وارد کنید..." ${required}>
                    </div>
                `;
                }
                if(custom_field.cf_type === "number"){
                    fieldHtml = `
                    <div class="col-md-6 custom-field-container" data-service="${custom_field.cf_service_code}">
                        <label class="form-label">${custom_field.cf_title}${star}</label>
                        <input type="number"
                               name="custom_field_${custom_field.cf_code}"
                               class="form-control"
                               placeholder="0" ${required}>
                    </div>
                `;
                }
                if(custom_field.cf_type === "select"){
                    let options = '<option value="">انتخاب کنید</option>';
                    if (custom_field.cf_options) {
                        try {
                            const optionsList = JSON.parse(custom_field.cf_options);
                            optionsList.forEach(function(option) {
                                options += `<option value="${option.trim()}">${option.trim()}</option>`;
                            });
                        } catch (e) {
                            console.error('Error parsing options for field', custom_field.cf_code);
                        }
                    }

                    fieldHtml = `
                    <div class="col-md-6 custom-field-container" data-service="${custom_field.cf_service_code}">
                        <label class="form-label">${custom_field.cf_title}${star}</label>
                        <select name="custom_field_${custom_field.cf_code}" class="form-select" ${required}>
                            ${options}
                        </select>
                    </div>
                `;
                }
                if (fieldHtml) {
                    fields_box.insertAdjacentHTML('beforeend', fieldHtml);
                }
            }
        }
        if(fields_box.innerHTML !== ""){
            document.getElementById('custom_fields_section').style.display = "block";
        }
    }
    let custom_fields = [];
    function lab_code_change(select) {
        const lab_code = select.value;

        if (!lab_code) {
            // Clear services dropdown if no lab is selected
            $('select[name="service_code"]').html('<option value="">ابتدا لابرتوار را انتخاب کنید</option>');
            $('.custom-field-container').remove();
            window.labCustomFields = [];
            return;
        }

        $.ajax({
            url: 'functions/add_order_funcs.php',
            type: 'POST',
            dataType: 'json',
            data: {
                action: 'get_lab_services',
                'add-order-lab-code': lab_code
            },
            success: function(response) {
                console.log(response);

                if (response.success && response.services) {
                    custom_fields = response.custom_fields;
                    // Clear and populate services dropdown
                    let servicesHtml = '<option value="">انتخاب کنید</option>';

                    // Group services by category if categories are available
                    if (response.categories && response.categories.length > 0) {
                        response.categories.forEach(function(category) {
                            servicesHtml += `<optgroup label="${category.category_title}">`;

                            response.services.forEach(function(service) {
                                if (service.service_category_code === category.service_category_code) {
                                    servicesHtml += `<option value="${service.service_code}">${service.service_title}</option>`;
                                }
                            });

                            servicesHtml += '</optgroup>';
                        });
                    } else {
                        // If no categories, just list all services
                        response.services.forEach(function(service) {
                            servicesHtml += `<option value="${service.service_code}">${service.service_title}</option>`;
                        });
                    }

                    // Update the services dropdown
                    $('select[name="service_code"]').html(servicesHtml);

                    // Refresh Select2 if it's initialized
                    if ($('select[name="service_code"]').hasClass('select2-hidden-accessible')) {
                        $('select[name="service_code"]').select2('destroy').select2({
                            placeholder: 'انتخاب کنید',
                            allowClear: true
                        });
                    }

                    // Store custom fields globally for later use
                    window.labCustomFields = response.custom_fields || [];

                } else {
                    $('select[name="service_code"]').html('<option value="">هیچ سرویسی یافت نشد</option>');
                }
            },
            error: function(xhr, status, error) {
                console.error('AJAX Error:', error);
                console.error('Response:', xhr.responseText);
                alert('خطا در دریافت اطلاعات سرویس‌ها');
                $('select[name="service_code"]').html('<option value="">خطا در بارگذاری سرویس‌ها</option>');
            }
        });
    }
</script>
<script>
    let upld_fls_codes = [];
    function delay(ms) {
        return new Promise(resolve => setTimeout(resolve, ms));
    }
    function truncateWithDots(str) {
        if (str.length <= 10) return str; // nothing to truncate
        return str.slice(0, 10) + '...';
    }
    $(function () {
        $("#upload_file").on("input", function () {
            let files = $("#upload_file")[0].files;
            if (!files.length) {
                alert("لطفا یک یا چند فایل انتخاب کنید.");
                return;
            }
            else {
                $('#modalCenter').modal('show');
            }

            let formData = new FormData();
            $.each(files, function (i, file) {
                formData.append("uploaded_file[]", file);
            });

            $.ajax({
                url: "<?=ROOT?>functions/add_order_upload_funcs.php", // مرحله اول: به لوکال
                type: "POST",
                data: formData,
                processData: false,
                contentType: false,
                xhr: function () {
                    let xhr = new window.XMLHttpRequest();
                    xhr.upload.addEventListener("progress", function (evt) {
                        if (evt.lengthComputable) {
                            let percent = (evt.loaded / evt.total) * 100;
                            $("#uploadProgress")
                                .css("width", percent.toFixed(2) + "%")
                                .attr("aria-valuenow", percent.toFixed(2))
                                .text(percent.toFixed(0) + "%");
                        }
                    }, false);
                    return xhr;
                },
                success: function (response) {
                    const results = response.results;
                    document.getElementById('uploaded_files_box').innerHTML = "";
                    for (const result of results) {
                        let arr = JSON.parse(result['server_response']);
                        const code = arr.files[0].name;
                        const name = arr.files[0].original_name;
                        let arr2 = [code,name]
                        upld_fls_codes.push(arr2);
                    }
                    for (const upld_fls_code of upld_fls_codes) {
                        let tmpstring =  '\n' + '<button onclick="remove_file(\'' + upld_fls_code[0] + '\')" class="btn btn-label-primary waves-effect mt-2" type="button"><span class="ti-xs ti ti-x me-1"></span>' + truncateWithDots(upld_fls_code[1]) + '</button>'
                        document.getElementById('uploaded_files_box').innerHTML += tmpstring;
                    }
                    if (response.status === "ok") {
                        console.log(response);
                        delay(1000).then(() => {
                            let modalEl = document.getElementById('modalCenter');
                            let modalInstance = bootstrap.Modal.getOrCreateInstance(modalEl);
                            modalInstance.hide(); // بستن یا اجرای عمل
                            let new_tmp = [];
                            for (const upld_fls_code of upld_fls_codes) {
                                console.log(upld_fls_code);
                                new_tmp.push(upld_fls_code[0]);
                            }
                            console.log(new_tmp);
                            document.getElementById('add-file-codes').value = JSON.stringify(new_tmp);
                            console.log(upld_fls_codes);
                        });
                    } else {
                        alert("خطا: " + response.message);
                    }
                },
                error: function () {
                    alert("خطا در ارسال به functions/upload.php");
                }
            });
        });
    });
    function remove_file(code){
        let tmp = [];
        document.getElementById('uploaded_files_box').innerHTML = "";
        for (const upld_fls_code of upld_fls_codes) {
            if(upld_fls_code[0] !== code){
                tmp.push(upld_fls_code);
                let tmpstring =  "\n" + '<button onclick="remove_file(\'' + upld_fls_code[0] + '\')" class="btn btn-label-primary waves-effect mt-2" type="button"><span class="ti-xs ti ti-x me-1"></span>' + truncateWithDots(upld_fls_code[1]) + '</button>'
                document.getElementById('uploaded_files_box').innerHTML += tmpstring;
            }
        }
        upld_fls_codes = tmp;
        let new_tmp = [];
        for (const upld_fls_code of upld_fls_codes) {
            new_tmp.push(upld_fls_code[0]);
        }
        document.getElementById('add-file-codes').value = JSON.stringify(new_tmp);
        console.log(upld_fls_codes);
    }
</script>
</body>
</html>
