<?php
session_start();
require 'auth21.php';
if (empty($_SESSION['user_code'])) {
    header("Location: login");
    exit;
}
$user = getUser($pdo);
if ($user['account_status'] == "NOTSIGNEDUP") {
    header("Location: registration");
    exit;
}
?>
<!DOCTYPE html>
<html class="light-style layout-navbar-fixed layout-menu-fixed layout-compact" data-assets-path="../../assets/" data-template="vertical-menu-template-no-customizer" data-theme="theme-default" dir="rtl" lang="fa">

<head>
    <meta charset="UTF-8"/>
    <meta content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" name="viewport"/>
    <title>یونیت‌های دندانپزشکی | Vuexy</title>
    <link href="../../assets/img/favicon/favicon.ico" rel="icon" type="image/x-icon"/>
    <link href="../../assets/vendor/fonts/fontawesome.css" rel="stylesheet"/>
    <link href="../../assets/vendor/fonts/tabler-icons.css" rel="stylesheet"/>
    <link href="../../assets/vendor/fonts/flag-icons.css" rel="stylesheet"/>
    <link href="../../assets/vendor/css/rtl/core.css" rel="stylesheet"/>
    <link href="../../assets/vendor/css/rtl/theme-default.css" rel="stylesheet"/>
    <link href="../../assets/css/demo.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/node-waves/node-waves.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/typeahead-js/typeahead.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/select2/select2.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/@form-validation/form-validation.css" rel="stylesheet"/>
    <link rel="stylesheet" href="../../assets/vendor/libs/sweetalert2/sweetalert2.css"/>
    <script src="../../assets/vendor/js/helpers.js"></script>
    <script src="../../assets/js/jquery-3.6.0.min.js"></script>
    <script src="../../assets/vendor/libs/sweetalert2/sweetalert2.js"></script>
    <script src="../../assets/js/config.js"></script>
    <link href="../../assets/css/rtl.css" rel="stylesheet"/>
</head>

<body>
<div class="layout-wrapper layout-content-navbar">
    <div class="layout-container">
        <?php require_once 'sidebar.php';?>
        <div class="layout-page">
            <?php require_once 'navbar.php';?>
            <div class="content-wrapper">
                <div class="container-xxl flex-grow-1 container-p-y">
                    <div class="card">
                        <div class="card-header border-bottom">
                            <h5 class="card-title mb-3">یونیت‌های دندانپزشکی</h5>
                            <button class="btn btn-secondary add-new btn-primary waves-effect waves-light" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasAddUnit">
                                <i class="ti ti-plus me-0 me-sm-1 ti-xs"></i>
                                <span class="d-none d-sm-inline-block">افزودن یونیت</span>
                            </button>
                        </div>
                        <div class="card-datatable table-responsive">
                            <table class="datatables-units table">
                                <thead class="border-top">
                                <tr>
                                    <th>نام</th>
                                    <th>موقعیت</th>
                                    <th>وضعیت</th>
                                    <th>دندانپزشکان</th>
                                    <th>عملیات</th>
                                </tr>
                                </thead>
                            </table>
                        </div>
                        <script>
                            $(document).ready(function () {
                                $('.datatables-units').DataTable({
                                    processing: true,
                                    ajax: {
                                        url: 'functions/units_funcs.php',
                                        type: 'POST',
                                        data: { action: 'load_units' },
                                        dataSrc: 'data'
                                    },
                                    columns: [
                                        { data: 'name' },
                                        { data: 'location' },
                                        { data: 'status' },
                                        { data: 'dentists' },
                                        { data: 'actions', orderable: false, searchable: false }
                                    ],
                                    language: { url: '//cdn.datatables.net/plug-ins/1.13.4/i18n/fa.json' }
                                });
                            });
                            $(document).on('click', '.delete-unit', function () {
                                const unitId = $(this).data('code');
                                Swal.fire({
                                    title: 'مطمئنی؟',
                                    text: 'این یونیت برای همیشه حذف خواهد شد!',
                                    icon: 'warning',
                                    showCancelButton: true,
                                    confirmButtonText: 'بله, حذف شود!',
                                    cancelButtonText: 'بازگشت',
                                    customClass: {
                                        confirmButton: 'btn btn-danger me-3 waves-effect waves-light',
                                        cancelButton: 'btn btn-label-secondary waves-effect waves-light'
                                    },
                                    buttonsStyling: false
                                }).then(function (result) {
                                    if (result.isConfirmed) {
                                        fetch('functions/units_funcs.php', {
                                            method: 'POST',
                                            body: new URLSearchParams({ action: 'delete_unit', code: unitId })
                                        })
                                            .then(r => r.json())
                                            .then(data => {
                                                if (data.success) {
                                                    $('.datatables-units').DataTable().ajax.reload();
                                                    Swal.fire({
                                                        icon: 'success',
                                                        title: 'حذف شد!',
                                                        text: data.message || 'یونیت با موفقیت حذف شد.',
                                                        confirmButtonText: 'باشه',
                                                        customClass: { confirmButton: 'btn btn-success waves-effect waves-light' }
                                                    });
                                                } else {
                                                    Swal.fire({
                                                        icon: 'error',
                                                        title: 'خطا',
                                                        text: data.error || 'خطایی در حذف رخ داد.',
                                                        confirmButtonText: 'باشه',
                                                        customClass: { confirmButton: 'btn btn-danger waves-effect waves-light' }
                                                    });
                                                }
                                            });
                                    }
                                });
                            });
                        </script>
                        <!-- Offcanvas -->
                        <div class="offcanvas offcanvas-end" id="offcanvasAddUnit" tabindex="-1">
                            <div class="offcanvas-header">
                                <h5 class="offcanvas-title">افزودن یونیت</h5>
                                <button class="btn-close text-reset" data-bs-dismiss="offcanvas"></button>
                            </div>
                            <div class="offcanvas-body mx-0 flex-grow-0 pt-0 h-100">
                                <form id="addNewUnitForm">
                                    <div class="mb-3">
                                        <label class="form-label" for="unit-name">نام یونیت</label>
                                        <input class="form-control" id="unit-name" name="unit-name" placeholder="یونیت مرکزی" type="text"/>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label" for="unit-location">موقعیت</label>
                                        <input class="form-control" id="unit-location" name="unit-location" placeholder="اتاق 1" type="text"/>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label" for="unit-status">وضعیت</label>
                                        <select class="form-select" id="unit-status" name="unit-status">
                                            <option value="available">آزاد</option>
                                            <option value="in_use">در حال استفاده</option>
                                            <option value="out_of_order">خراب</option>
                                        </select>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label" for="unit-dentists">دندانپزشکان تخصیص داده شده</label>
                                        <select class="form-select select2" id="unit-dentists" name="unit-dentists[]" multiple>
                                            <?php
                                            // assuming you have PDO in $pdo and decryptData() available
                                            session_start();
                                            $officeCode = $_SESSION['user_code'] ?? null;

                                            if ($officeCode) {
                                                $stmt = $pdo->prepare("
        SELECT id, dentist_code,
               dentist_firstname_encrypted,
               dentist_lastname_encrypted,iv,salt,enc_code
        FROM dentists
        WHERE status = 'ACTIVE'
          AND office_code = :officeCode
        ORDER BY dentist_firstname_encrypted
    ");
                                                $stmt->execute(['officeCode' => $officeCode]);
                                                while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                                                    $dentist_encrypted[] = [
                                                        'dentist_firstname_encrypted' => decryptData($row['dentist_firstname_encrypted']),
                                                        'dentist_lastname_encrypted'  => decryptData($row['dentist_lastname_encrypted'])
                                                    ];
                                                    $iv = $row['iv'];
                                                    $salt = $row['salt'];
                                                    $enc_code = $row['enc_code'];
                                                    $tmp_dentist = get_decrypted_data($dentist_encrypted,$iv,$salt,$enc_code);
                                                    $fname = $tmp_dentist['dentist_firstname_encrypted'];
                                                    $lname = $tmp_dentist['dentist_lastname_encrypted'];
                                                    $label = $fname . ' ' . $lname;
                                                    echo '<option value="'.$row['dentist_code'].'">'.htmlspecialchars($label).'</option>';
                                                }
                                            }
                                            ?>
                                        </select>
                                    </div>
                                    <button id="addUnitBtn" class="btn btn-primary me-sm-3 me-1 data-submit" type="button">افزودن</button>
                                    <button class="btn btn-label-secondary" data-bs-dismiss="offcanvas" type="reset">لغو</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <script>
                    // Load dentists list
                    $('#offcanvasAddUnit').on('show.bs.offcanvas', function () {
                        fetch('functions/dentists_funcs.php', {
                            method: 'POST',
                            body: new URLSearchParams({ action: 'load_dentists_list' })
                        })
                            .then(r => r.json())
                            .then(data => {
                                if (data.success) {
                                    const select = $('#unit-dentists');
                                    select.empty();
                                    data.dentists.forEach(d => {
                                        select.append(`<option value="${d.id}">${d.firstname} ${d.lastname}</option>`);
                                    });
                                    select.select2({ dropdownParent: $('#offcanvasAddUnit') });
                                }
                            });
                    });
                    // Add Unit
                    document.getElementById('addUnitBtn').addEventListener('click', function () {
                        const form = document.getElementById('addNewUnitForm');
                        const formData = new FormData(form);
                        console.log(document.getElementById('unit-dentists').value);
                        formData.append('action', 'add_unit');
                        fetch('functions/units_funcs.php', { method: 'POST', body: formData })
                            .then(r => r.json())
                            .then(data => {
                                if (data.success) {
                                    Swal.fire({
                                        icon: 'success',
                                        title: 'موفق!',
                                        text: data.message || 'یونیت با موفقیت اضافه شد.',
                                        confirmButtonText: 'باشه',
                                        customClass: { confirmButton: 'btn btn-success waves-effect waves-light' }
                                    });
                                    $('.datatables-units').DataTable().ajax.reload();
                                    form.reset();
                                } else {
                                    Swal.fire({
                                        icon: 'error',
                                        title: 'خطا',
                                        text: data.error || 'خطا در ذخیره یونیت',
                                        confirmButtonText: 'باشه',
                                        customClass: { confirmButton: 'btn btn-danger waves-effect waves-light' }
                                    });
                                }
                            });
                    });
                </script>
            </div>
        </div>
    </div>
</div>
<!-- / Layout wrapper -->
<!-- Core JS -->
<!-- build:js assets/vendor/js/core.js -->
<script src="../../assets/vendor/libs/jquery/jquery.js"></script>
<script src="../../assets/vendor/libs/popper/popper.js"></script>
<script src="../../assets/vendor/js/bootstrap.js"></script>
<script src="../../assets/vendor/libs/node-waves/node-waves.js"></script>
<script src="../../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="../../assets/vendor/libs/hammer/hammer.js"></script>
<script src="../../assets/vendor/libs/i18n/i18n.js"></script>
<script src="../../assets/vendor/libs/typeahead-js/typeahead.js"></script>
<script src="../../assets/vendor/js/menu.js"></script>
<!-- endbuild -->
<!-- Vendors JS -->
<script src="../../assets/vendor/libs/moment/moment.js"></script>
<script src="../../assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js"></script>
<script src="../../assets/vendor/libs/datatables-bs5/i18n/fa.js"></script>
<script src="../../assets/vendor/libs/select2/select2.js"></script>
<script src="../../assets/vendor/libs/select2/i18n/fa.js"></script>
<script src="../../assets/vendor/libs/@form-validation/popular.js"></script>
<script src="../../assets/vendor/libs/@form-validation/bootstrap5.js"></script>
<script src="../../assets/vendor/libs/@form-validation/auto-focus.js"></script>
<script src="../../assets/vendor/libs/cleavejs/cleave.js"></script>
<script src="../../assets/vendor/libs/cleavejs/cleave-phone.js"></script>
<!-- Main JS -->
<script src="../../assets/js/main.js"></script>
<!-- Page JS -->
</body>
</html>
