<?php
require_once 'config.php'; // contains encryptData() and decryptData()

$encrypted = 'a';
$decrypted = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!empty($_POST['plain_text']) && empty($_POST['encrypted_text'])) {
        // Encrypt
        $encrypted = encryptData(trim($_POST['plain_text']));
    } elseif (!empty($_POST['encrypted_text']) && empty($_POST['plain_text'])) {
        // Decrypt
        $decrypted = decryptData(trim($_POST['encrypted_text']));
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Encrypt / Decrypt</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        textarea { width: 100%; height: 80px; }
        input[type=submit] { margin-top: 10px; padding: 8px 15px; }
        .result { margin-top: 20px; padding: 10px; border: 1px solid #ccc; background: #f8f8f8; }
    </style>
</head>
<body>
<h2>Encrypt / Decrypt Tool</h2>
<form method="post">
    <label>Text to Encrypt:</label>
    <textarea name="plain_text"><?php echo isset($_POST['plain_text']) ? htmlspecialchars($_POST['plain_text']) : ''; ?></textarea>

    <label>Encrypted Text to Decrypt:</label>
    <textarea name="encrypted_text"><?php echo isset($_POST['encrypted_text']) ? htmlspecialchars($_POST['encrypted_text']) : ''; ?></textarea>

    <input type="submit" value="Submit">
</form>

<?php if ($encrypted): ?>
    <div class="result"><strong>Encrypted:</strong><br><?php echo htmlspecialchars($encrypted); ?></div>
<?php endif; ?>

<?php if ($decrypted): ?>
    <div class="result"><strong>Decrypted:</strong><br><?php echo htmlspecialchars($decrypted); ?></div>
<?php endif; ?>
</body>
</html>
