<?php
header('Content-Type: application/json');
require_once "config.php";

try {
    session_start();
    $officeCode = $_SESSION['user_code'] ?? null;
    if (!$officeCode) {
        throw new Exception("No office code found in session.");
    }
} catch (Throwable $e) {
    echo json_encode([
        'success' => false,
        'error'   => $e->getMessage()
    ]);
}
if (!empty($_FILES['uploaded_file']['name'][0])) {
    $targetServerUrl = "https://cdn12.dentopin.com/upload.php"; // سرور مقصد
    $folderCode = uniqid() . '_' . md5($officeCode);
    $uploadedResults = [];
    foreach ($_FILES['uploaded_file']['tmp_name'] as $key => $tmpName) {
        $name = $_FILES['uploaded_file']['name'][$key];
        $type = $_FILES['uploaded_file']['type'][$key];
        $randomName = uniqid() . '_' . md5(rand(1000000,9999999)) . '_' . rand(100000,999999);
        $extension = pathinfo($name, PATHINFO_EXTENSION);
// یکسان‌سازی حروف (مثلاً JPG → jpg)
        $extension = strtolower($extension);
        $url = "https://cdn12.dentopin.com/uploads/" . $folderCode . "/" . $randomName;
        $stmt = $pdo->prepare("
        INSERT INTO uploaded_files (file_code,folder_code, user_code, original_name,file_extension,url) 
        VALUES (?, ?, ?, ?, ?, ?)
    ");
        $stmt->execute([htmlspecialchars($randomName), htmlspecialchars($folderCode), $officeCode,htmlspecialchars($name),htmlspecialchars($extension),htmlspecialchars($url)]);

        $ch = curl_init();
        $cFile = new CURLFile($tmpName, $type, $name);
        $postData = ['uploaded_file[]' => $cFile,'folder_code' => $folderCode,'file_name' => $randomName];

        curl_setopt($ch, CURLOPT_URL, $targetServerUrl);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $serverResponse = curl_exec($ch);
        $error = curl_error($ch);
        curl_close($ch);

        if ($error) {
            $uploadedResults[] = [
                'name' => $name,
                'status' => 'error',
                'message' => $error
            ];
        } else {
            $uploadedResults[] = [
                'name' => $name,
                'status' => 'success',
                'server_response' => $serverResponse
            ];
        }
    }

    echo json_encode([
        'status' => 'ok',
        'results' => $uploadedResults
    ], JSON_UNESCAPED_UNICODE);
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'هیچ فایلی ارسال نشده.'
    ], JSON_UNESCAPED_UNICODE);
}
