<?php
header('Content-Type: application/json; charset=utf-8');
require_once "config.php";
require_once "jdf.php";
try {
    session_start();
    $action = $_POST['action'] ?? null;
    if (!$action) throw new Exception("No action provided.");

    switch ($action) {
        case 'load_treatments':
            loadTreatments($pdo,$pdo_lab);
            break;
        case 'load_done_services':
            loadDoneServices($pdo,$pdo_lab);
            break;
        case 'load_appointments':
            loadAppointments($pdo,$pdo_lab);
            break;
        case 'load_messages':
            loadMessages($pdo,$pdo_lab);
            break;
        case 'load_records':
            loadRecords($pdo,$pdo_lab);
            break;
        case 'load_payments':
            loadPayments($pdo,$pdo_lab);
            break;
        case 'add_record':
            addRecord($pdo, $pdo_lab);
            break;
        case 'add_payment':
            addPayment($pdo, $pdo_lab);
            break;
        case 'edit_payment':
            editPayment($pdo, $pdo_lab);
            break;
        case 'delete_done_services':
            deleteDoneServices($pdo, $officeCode);
            exit;
        case 'delete_payment':
            deletePayment($pdo, $officeCode);
            exit;
        default:
            throw new Exception("Invalid action: " . htmlspecialchars($action));
    }
} catch (Throwable $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
    file_put_contents(__DIR__ . '/load_order_error.txt', $e->getMessage());
}

// === FUNCTIONS ===

function loadTreatments($pdo,$pdo_lab) {
    if (empty($_POST['code'])) {
        echo json_encode(['success' => false, 'error' => 'شناسه بیمار ارسال نشده است']);
        return;
    }
    $patientCode = trim($_POST['code']);
    $officeCode =  $_SESSION['user_code'] ?? null;
    $stmt = $pdo->prepare("
        SELECT service_code, service_title, service_category_code
        FROM services
        WHERE status = 'ACTIVE' AND COALESCE(hide_default_for, '') NOT LIKE :pattern
          AND (office_code = :office_code OR office_code = 'DEFAULT')
    ");
    $stmt->execute([':office_code' => $officeCode, ':pattern' => '%"'.$officeCode.'"%']);
    $services = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $services[] = $row;
    }

    $stmt = $pdo->prepare("SELECT * FROM dentists WHERE office_code = ? AND  status = 'ACTIVE'");
    $stmt->execute([$officeCode]);
    $dentists = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $dentists[$row['dentist_code']] = $row;
    }

    $service_title = "نامشخص";
    $stmt = $pdo->prepare("SELECT * FROM treatments WHERE clinic_code = ? AND patient_code = ?");
    $stmt->execute([$officeCode,$patientCode]);
    $treatments = [];
    $counter = 1;

    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $teeth_attr = htmlspecialchars($row['teeth'], ENT_QUOTES, 'UTF-8');
        $service_cat = "";
        $teeth = generateTeethChartHtml($row['teeth'],$row['dentition']);
        foreach ($services as $service){
            if($service['service_code'] == $row['service_code']){
                $service_title = $service['service_title'];
                $service_cat = $service['service_category_code'];
            }
        }
        $status_code = $row['status'];

        $status = '<span class="badge bg-label-warning">ناتمام</span>';
        if($status_code == "NOTDONE"){
            $status = '<span class="badge bg-label-warning">ناتمام</span>';
        }
        if($status_code == "MIDTREATMENT"){
            $status =  '<span class="badge bg-label-primary">حین درمان</span>';
        }
        if($status_code == "DONE"){
            $status = '<span class="badge bg-label-success">تمام شده</span>';
        }
        if($status_code == "CANCELED"){
            $status = '<span class="badge bg-label-danger">لغو شده</span>';
        }
        $dentist_name = "نامشخص";
        if($row['dentist_code'] == "MANUAL"){
            $dentist_name = $row['manual_dentist_name'];
        }
        else{
            $dentist_name_enc = decryptData($dentists[$row['dentist_code']]['dentist_fullname_encrypted']);
            $dentist_encrypted = ['dentist_fullname_encrypted'=>$dentist_name_enc];
            $iv = $dentists[$row['dentist_code']]['iv'];
            $salt = $dentists[$row['dentist_code']]['salt'];
            $enc_code = $dentists[$row['dentist_code']]['enc_code'];
            $tmp_dentist = get_decrypted_data($dentist_encrypted,$iv,$salt,$enc_code);
        }
        $treatments[] = [
            'radif'     => $counter,
            'tooth'     => $teeth,
            'dentist' => 'دکتر ' . $tmp_dentist['dentist_fullname_encrypted'],
            'service' => $service_title,
            'created-date' => $row['shamsi_date'],
            'start-date' => $row['start_date'],
            'finish-date'   => $row['finish_date'],
            'status'   => $status,
            'actions'  => '<a href="'. ROOT . 'appointments?pcode='.htmlspecialchars($patientCode).'&service=' . htmlspecialchars($row['service_code']) . '&service-cat=' .  htmlspecialchars($service_cat) . '&treatment-plan=' . htmlspecialchars($row['treatment_code']) . '" class="btn btn-sm btn-outline-primary">تعیین نوبت</a>
            <a href="'. ROOT . 'cases/'.htmlspecialchars($patientCode).'?tab=addDoneServices'  . '&treatment-plan=' . htmlspecialchars($row['treatment_code']) . '" class="btn btn-sm btn-outline-primary">ثبت درمان</a>
            <button data-status="' . $status_code . '" data-code="'. $row['treatment_code'] . '" data-servicecode="'. $row['service_code'] . '" data-teeth="' . $teeth_attr . '" data-dentition="'. $row['dentition'] . '" data-note="'. $row['note'] . '" onclick="load_edit_modal_data(this);" class="btn btn-sm btn-primary" data-bs-target="#editTreatmentModal" data-bs-toggle="modal">ویرایش</a>'
        ];
        $counter+=1;
    }
    echo json_encode(['data' => $treatments]);
}
function loadDoneServices($pdo,$pdo_lab) {
    if (empty($_POST['code'])) {
        echo json_encode(['success' => false, 'error' => 'شناسه بیمار ارسال نشده است']);
        return;
    }
    $patientCode = trim($_POST['code']);
    $officeCode =  $_SESSION['user_code'] ?? null;
    $stmt = $pdo->prepare("
        SELECT service_code, service_title, service_category_code
        FROM services
        WHERE status = 'ACTIVE' AND COALESCE(hide_default_for, '') NOT LIKE :pattern
          AND (office_code = :office_code OR office_code = 'DEFAULT')
    ");
    $stmt->execute([':office_code' => $officeCode, ':pattern' => '%"'.$officeCode.'"%']);
    $services = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $services[] = $row;
    }

    $stmt = $pdo->prepare("SELECT * FROM dentists WHERE office_code = ? AND  status = 'ACTIVE'");
    $stmt->execute([$officeCode]);
    $dentists = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $dentists[$row['dentist_code']] = $row;
    }

    $service_title = "نامشخص";
    $stmt = $pdo->prepare("SELECT * FROM done_treatments WHERE clinic_code = ? AND patient_code = ? AND status != 'DELETED'");
    $stmt->execute([$officeCode,$patientCode]);
    $treatments = [];
    $counter = 1;

    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $teeth_attr = htmlspecialchars($row['teeth'], ENT_QUOTES, 'UTF-8');
        $service_cat = "";
        $teeth = generateTeethChartHtml($row['teeth'],$row['dentition']);
        foreach ($services as $service){
            if($service['service_code'] == $row['service_code']){
                $service_title = $service['service_title'];
                $service_cat = $service['service_category_code'];
            }
        }
        $status_code = $row['status'];

        $status = '<span class="badge bg-label-warning">ناتمام</span>';
        if($status_code == "NOTDONE"){
            $status = '<span class="badge bg-label-warning">ناتمام</span>';
        }
        if($status_code == "MIDTREATMENT"){
            $status =  '<span class="badge bg-label-primary">حین درمان</span>';
        }
        if($status_code == "DONE"){
            $status = '<span class="badge bg-label-success">تمام شده</span>';
        }
        if($status_code == "CANCELED"){
            $status = '<span class="badge bg-label-danger">لغو شده</span>';
        }
        $dentist_name = "نامشخص";
        if($row['dentist_code'] == "MANUAL"){
            $tmp_dentist['dentist_fullname_encrypted'] = $row['manual_dentist_name'];
        }
        else{
            $dentist_name_enc = decryptData($dentists[$row['dentist_code']]['dentist_fullname_encrypted']);
            $dentist_encrypted = ['dentist_fullname_encrypted'=>$dentist_name_enc];
            $iv = $dentists[$row['dentist_code']]['iv'];
            $salt = $dentists[$row['dentist_code']]['salt'];
            $enc_code = $dentists[$row['dentist_code']]['enc_code'];
            $tmp_dentist = get_decrypted_data($dentist_encrypted,$iv,$salt,$enc_code);
        }
        $treatments[] = [
            'radif'     => $counter,
            'tooth'     => $teeth,
            'dentist' => 'دکتر ' . $tmp_dentist['dentist_fullname_encrypted'],
            'service' => $service_title,
            'created-date' => $row['shamsi_date'],
            'start-date' => $row['start_date'],
            'finish-date'   => $row['finish_date'],
            'status'   => $status,
            'actions'  => '<a href="' . htmlspecialchars(ROOT . 'cases/'.htmlspecialchars($patientCode).'?tab=addDoneServices'  . '&done-code=' . htmlspecialchars($row['done_code'])) . '&mode=readOnly' .'" class="btn btn-sm m-1 btn-outline-primary" data-code="'.$row['done_code'].'">مشاهده</a><a href="' . htmlspecialchars(ROOT . 'cases/'.htmlspecialchars($patientCode).'?tab=addDoneServices'  . '&done-code=' . htmlspecialchars($row['done_code'])) . '&mode=edit' .'" class="btn btn-sm btn-primary" data-code="'.$row['done_code'].'">ویرایش</a><button class="btn btn-sm m-1 btn-danger delete-treatment" data-code="'.$row['done_code'].'">حذف</button>'
        ];
        $counter+=1;
    }
    echo json_encode(['data' => $treatments]);
}
function loadAppointments($pdo,$pdo_lab) {
    if (empty($_POST['code'])) {
        echo json_encode(['success' => false, 'error' => 'شناسه بیمار ارسال نشده است']);
        return;
    }
    $patientCode = trim($_POST['code']);
    $officeCode =  $_SESSION['user_code'] ?? null;
    $stmt = $pdo->prepare("
        SELECT *
        FROM services
        WHERE status = 'ACTIVE' AND COALESCE(hide_default_for, '') NOT LIKE :pattern
          AND (office_code = :office_code OR office_code = 'DEFAULT')
    ");
    $stmt->execute([':office_code' => $officeCode, ':pattern' => '%"'.$officeCode.'"%']);
    $services = $stmt->fetchAll(PDO::FETCH_ASSOC);
    $stmt = $pdo->prepare("SELECT * FROM dentists WHERE office_code = ?");
    $stmt->execute([$officeCode]);
    $dentists = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $dentists[] = $row;
    }
    $stmt = $pdo->prepare("SELECT * FROM appointments WHERE office_code = ? AND patient_code = ?");
    $stmt->execute([$officeCode,$patientCode]);
    $appointments = [];
    $counter = 1;
    $service_title = "نامشخص";
    $dentist_name = "نامشخص";
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        foreach ($services as $service){
            if($service['service_code'] == $row['service_code']){
                $service_title = $service['service_title'];
            }
        }
        foreach ($dentists as $dentist){
            if($dentist['dentist_code'] == $row['dentist_code']){
                $dentist_name_enc = decryptData($dentist['dentist_fullname_encrypted']);
                $dentist_encrypted = ['dentist_fullname_encrypted'=>$dentist_name_enc];
                $iv = $dentist['iv'];
                $salt = $dentist['salt'];
                $enc_code = $dentist['enc_code'];
                $tmp_dentist = get_decrypted_data($dentist_encrypted,$iv,$salt,$enc_code);
                $dentist_name = $tmp_dentist['dentist_fullname_encrypted'];
            }
        }
        $status_code = $row['status'];
        list($date, $time) = explode(' ', $row['start_datetime']);

// فقط ساعت و دقیقه
        $time_only = substr($time, 0, 5);
        $start_dateGregorian = jalaliDateTimeToGregorian($row['start_datetime']);
        $dateGiven = new DateTime($start_dateGregorian);
        $now = new DateTime(); // زمان فعلی سرور

        $status = '<span class="badge bg-label-primary">فعال</span>';
        if($status_code == "ACTIVE"){
            $status = '<span class="badge bg-label-primary">فعال</span>';
            if ($dateGiven < $now) {
                $status = '<span class="badge bg-label-warning">گذشته</span>';
            }
        }
        if($status_code == "DELETED"){
            $status =  '<span class="badge bg-label-danger">پاک شده</span>';
        }
        if($status_code == "DONE"){
            $status = '<span class="badge bg-label-success">تمام شده</span>';
        }
        if($status_code == "CANCELED"){
            $status = '<span class="badge bg-label-warning">لغو شده</span>';
        }
        $appointments[] = [
            'radif'     => $counter,
            'date'     => str_replace('-','/',$date),
            'hour' => $time_only,
            'service' => $service_title,
            'dentist' =>  'دکتر ' . $dentist_name,
            'status'   => $status,
            'actions'  => '<button class="btn btn-sm btn-primary" data-bs-target="#editTreatmentModal" data-bs-toggle="modal">ویرایش</a>'
        ];
        $counter+=1;
    }
    echo json_encode(['data' => $appointments]);
}
function loadMessages($pdo,$pdo_lab) {
    $officeCode =  $_SESSION['user_code'] ?? null;
    if (empty($_POST['code'])) {
        echo json_encode(['success' => false, 'error' => 'شناسه بیمار ارسال نشده است']);
        return;
    }
    $messages = [];

    $code = trim($_POST['code']);
    $stmt = $pdo->prepare("
        SELECT patient_phone_encrypted
        FROM patients
        WHERE patient_code = :code
          AND office_code = :office_code
        LIMIT 1
    ");
    $stmt->execute([
        ':code'        => $code,
        ':office_code' => $officeCode
    ]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($row) {
        $receiver_number = decryptData($row['patient_phone_encrypted']);
        $stmt2 = $pdo->prepare("SELECT * FROM messages WHERE sender_code = ? AND receiver_number = ?");
        $stmt2->execute([$officeCode,$receiver_number]);
        $counter = 1;
        while ($row2 = $stmt2->fetch(PDO::FETCH_ASSOC)) {
            // جدا کردن بخش تاریخ و زمان
            list($datePart, $timePart) = explode(' ', $row2['date']);
            list($gy, $gm, $gd) = explode('-', $datePart);

// تبدیل به تاریخ شمسی
            list($jy, $jm, $jd) = gregorian_to_jalali($gy, $gm, $gd);

// استخراج زمان از بخش دوم، فقط ساعت، دقیقه، ثانیه
            list($hour, $minute, $secondMs) = explode(':', $timePart);
            list($second, $micro) = explode('.', $secondMs); // جدا کردن میکروثانیه
            $messages[] = [
                'radif'     => $counter,
                'date'     => "{$jy}/{$jm}/{$jd}",
                'hour' => "{$hour}:{$minute}:{$second}",
                'message' => nl2br(decryptData($row2['message']))
            ];
            $counter+=1;
        }
    }
    echo json_encode(['data' => $messages]);
}
function loadRecords($pdo,$pdo_lab) {
    $officeCode =  $_SESSION['user_code'] ?? null;
    if (empty($_POST['code'])) {
        echo json_encode(['success' => false, 'error' => 'شناسه بیمار ارسال نشده است']);
        return;
    }
    $records = [];

    $code = trim($_POST['code']);
    $stmt = $pdo->prepare("
        SELECT type,record_name,record_note,record_code,count,created_at
        FROM records
        WHERE patient_code = :code
          AND office_code = :office_code
    ");
    $stmt->execute([
        ':code'        => $code,
        ':office_code' => $officeCode
    ]);
    $counter = 1;
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)){
        list($datePart, $timePart) = explode(' ', $row['created_at']);
        list($gy, $gm, $gd) = explode('-', $datePart);

// تبدیل به تاریخ شمسی
        list($jy, $jm, $jd) = gregorian_to_jalali($gy, $gm, $gd);

// استخراج زمان از بخش دوم، فقط ساعت، دقیقه، ثانیه
        list($hour, $minute, $secondMs) = explode(':', $timePart);
        list($second, $micro) = explode('.', $secondMs); // جدا کردن میکروثانیه
        $records[] = [
            'radif'     => $counter,
            'type'     => $row['type'],
            'count' => $row['count'],
            'date' => "{$hour}:{$minute}:{$second}" . " - " . "{$jy}/{$jm}/{$jd}",
            'actions' => '<a target="_blank" href="'. ROOT . 'record/' . $row['record_code'] .  '" class="btn btn-sm btn-primary treatment-plan" data-code="'.$row['patient_code'].'">مشاهده رکورد</a>'
        ];
        $counter+=1;
    }
    echo json_encode(['data' => $records]);
}
function loadPayments($pdo,$pdo_lab) {
    $officeCode =  $_SESSION['user_code'] ?? null;
    if (empty($_POST['code'])) {
        echo json_encode(['success' => false, 'error' => 'شناسه بیمار ارسال نشده است']);
        return;
    }
    $payments = [];

    $code = trim($_POST['code']);
    $stmt = $pdo->prepare("
        SELECT *
        FROM patients_payments
        WHERE patient_code = :code
          AND office_code = :office_code AND status != 'DELETED'
    ");
    $stmt->execute([
        ':code'        => $code,
        ':office_code' => $officeCode
    ]);
    $counter = 1;
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)){
        list($datePart, $timePart) = explode(' ', $row['date']);
        list($gy, $gm, $gd) = explode('-', $datePart);

// تبدیل به تاریخ شمسی
        list($jy, $jm, $jd) = gregorian_to_jalali($gy, $gm, $gd);

// استخراج زمان از بخش دوم، فقط ساعت، دقیقه، ثانیه
        list($hour, $minute, $secondMs) = explode(':', $timePart);
        list($second, $micro) = explode('.', $secondMs); // جدا کردن میکروثانیه
        $next_installment = "اقساطی نیست.";
        $status_code = $row['status'];
        if($row['payment_method'] == "اقساط"){
            $installments = json_decode($row['installments'], true);
            foreach ($installments as $installment){
                if($installment['status'] == "پرداخت نشده"){
                    $next_installment = $installment['date'];
                    $jdate = $next_installment; // or 1405/01/15

// 1️⃣ Normalize & split
                    list($jy, $jm, $jd) = array_map('intval', explode('/', $jdate));

// 2️⃣ Convert
                    list($gy, $gm, $gd) = jalali_to_gregorian($jy, $jm, $jd);

// 3️⃣ Format output
                    $result = sprintf(
                        '%d/%02d/%02d',
                        $gy,
                        $gm,
                        $gd
                    );
                    $targetDate = new DateTime($result);
                    $today = new DateTime('today');

                    if ($targetDate < $today) {
                        $status_code = "LATE";
                    } else {
                        $status_code = "NOTLATE";
                    }
                    break;
                }
                else{
                    if ($installment['status'] == "تاخیر"){
                        $status_code = "LATE";
                        break;
                    }
                }
            }
        }

        $status = '<span class="badge bg-label-warning">پرداخت نشده</span>';
        if($status_code == "PENDING"){
            $status = '<span class="badge bg-label-warning">پرداخت نشده</span>';
        }
        if($status_code == "DONE"){
            $status = '<span class="badge bg-label-success">پرداخت شده</span>';
        }
        if($status_code == "CANCELED"){
            $status = '<span class="badge bg-label-danger">لغو شده</span>';
        }
        if($status_code == "LATE"){
            $status = '<span class="badge bg-label-danger">تاخیر در پرداخت قسط</span>';
        }
        if($status_code == "NOTLATE"){
            $status = '<span class="badge bg-label-warning">منتظر پرداخت بعدی</span>';
        }
        $payments[] = [
            'radif'     => $counter,
            'method'     => $row['payment_method'],
            'primary_amount'  => thousand_sepr($row['primary_amount']),
            'discount'  => thousand_sepr($row['discount_amount']),
            'final_amount'  => thousand_sepr($row['final_amount']),
            'next_installment' => $next_installment,
            'date' => "{$hour}:{$minute}:{$second}" . " - " . "{$jy}/{$jm}/{$jd}",
            'status' => $status,
            'actions' => '<button type="button" onclick="load_edit_payment_modal_data(this)" class="btn btn-sm btn-primary m-1" data-paiddate="'.$row['paid_date'].'" data-method="'.$row['payment_method'].'" data-notes="'.$row['notes'].'" data-donetreatmentscodes="'.htmlspecialchars($row["done_treatments_codes"], ENT_QUOTES, "UTF-8") .'" data-primaryAmount="'.$row['primary_amount'].'" data-finalAmount="'.$row['final_amount'].'" data-discount="'.$row['discount_amount'].'" data-installments="'.htmlspecialchars($row['installments']).'" data-status="'.$row['status'].'" data-code="'.$row['payment_code'].'">ویرایش</button><button class="btn btn-sm btn-danger delete-payment" data-code="'.$row['payment_code'].'">حذف</button>'
        ];
        $counter+=1;
    }
    echo json_encode(['data' => $payments]);
}

// Helper to check if JSON is valid
function json_validate($string) {
    if (!is_string($string)) return false;
    json_decode($string);
    return json_last_error() === JSON_ERROR_NONE;
}
function addRecord($pdo, $officeCode) {
    $officeCode =  $_SESSION['user_code'] ?? null;
    $name  = trim($_POST['name'] ?? '');
    $type  = trim($_POST['type'] ?? '');
    $link  = trim($_POST['link'] ?? '');
    $notes  = trim($_POST['notes'] ?? '');
    $pcode  = trim($_POST['pcode'] ?? '');
    $files  = trim($_POST['files'] ?? '[]');
    $count = count(json_decode($files));
    if($count == 0)$count = 1;
    $record_code = uniqid("REC-") . '-' . substr(base64_encode(hash('sha256', $officeCode)), 0, 20) . '-' . substr(base64_encode(hash('sha256', $pcode)), 0, 20);

    $stmt = $pdo->prepare("
        INSERT INTO records (record_code,record_name,record_note,patient_code,office_code,type,link,files,count) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)
    ");

    $stmt->execute([$record_code,$name,$notes,$pcode,$officeCode,$type,$link,$files,$count]);

    echo json_encode(['data' => 'success']);
}
function addPayment($pdo, $officeCode) {
    $officeCode =  $_SESSION['user_code'] ?? null;
    $method  = trim($_POST['method'] ?? '');
    $primaryAmount  = trim($_POST['primaryAmount'] ?? '');
    $finalAmount  = trim($_POST['finalAmount'] ?? '');
    $discountAmount  = trim($_POST['discountAmount'] ?? '');
    $pcode  = trim($_POST['pcode'] ?? '');
    $done_treatments_codes = trim($_POST['done_treatments_codes'] ?? '');
    $installments = trim($_POST['installments'] ?? '');
    $notes = trim($_POST['notes'] ?? '');
    $paid_date = trim($_POST['paid_date'] ?? '');

    $payment_code = uniqid("PAITIENTPYMNT-") . '-' . substr(base64_encode(hash('sha256', $officeCode)), 0, 20) . '-' . substr(base64_encode(hash('sha256', $pcode)), 0, 20);
    if($method == "اقساط"){
        $status = "PENDING";
    }
    else{
        $status = "DONE";
    }
    $stmt = $pdo->prepare("
        INSERT INTO patients_payments (payment_code,done_treatments_codes,patient_code,payment_method,office_code,installments,primary_amount,discount_amount,final_amount,notes,paid_date,status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
    ");

    $stmt->execute([$payment_code,$done_treatments_codes,$pcode,$method,$officeCode,$installments,$primaryAmount,$discountAmount,$finalAmount,$notes,$paid_date,$status]);

    echo json_encode(['data' => 'success']);
}
function editPayment($pdo, $officeCode) {
    $officeCode =  $_SESSION['user_code'] ?? null;
    $method  = trim($_POST['method'] ?? '');
    $primaryAmount  = trim($_POST['primaryAmount'] ?? '');
    $finalAmount  = trim($_POST['finalAmount'] ?? '');
    $discountAmount  = trim($_POST['discountAmount'] ?? '');
    $pcode  = trim($_POST['pcode'] ?? '');
    $done_treatments_codes = trim($_POST['done_treatments_codes'] ?? '');
    $installments = trim($_POST['installments'] ?? '');
    $notes = trim($_POST['notes'] ?? '');
    $payment_code = trim($_POST['payment_code'] ?? '');
    $paid_date = trim($_POST['paid_date'] ?? '');

    if($method == "اقساط"){
        $status = "PENDING";
    }
    else{
        $status = "DONE";
    }
    $stmt = $pdo->prepare("
    UPDATE patients_payments
    SET
        done_treatments_codes = ?,
        patient_code          = ?,
        payment_method        = ?,
        office_code           = ?,
        installments          = ?,
        primary_amount        = ?,
        discount_amount       = ?,
        final_amount          = ?,
        notes                 = ?,
        paid_date             = ?,
        status                = ?
    WHERE payment_code = ?
");

    $stmt->execute([
        $done_treatments_codes,
        $pcode,
        $method,
        $officeCode,
        $installments,
        $primaryAmount,
        $discountAmount,
        $finalAmount,
        $notes,
        $paid_date,
        $status,
        $payment_code
    ]);

    echo json_encode(['data' => 'success']);
}
function deleteDoneServices($pdo,$officeCode) {
    $officeCode =  $_SESSION['user_code'] ?? null;

    if (empty($_POST['code'])) {
        echo json_encode(['success' => false, 'error' => 'شناسه درمان ارسال نشده است']);
        exit;
    }
    $code = trim($_POST['code']);
    try {
        $stmt = $pdo->prepare("
            UPDATE done_treatments
            SET status = 'DELETED'
            WHERE done_code = :code
              AND clinic_code = :office_code
        ");
        $stmt->execute([
            ':code'        => $code,
            ':office_code' => $officeCode
        ]);

        if ($stmt->rowCount()) {
            echo json_encode(['success' => true, 'message' => 'درمان با موفقیت حذف شد.']);
        } else {
            echo json_encode(['success' => false, 'error' => 'درمانی برای حذف یافت نشد.']);
        }
    } catch (Exception $e) {
        echo json_encode(['success' => false, 'error' => 'خطای پایگاه داده: ' . $e->getMessage()]);
    }
}
function deletePayment($pdo,$officeCode) {
    $officeCode =  $_SESSION['user_code'] ?? null;

    if (empty($_POST['code'])) {
        echo json_encode(['success' => false, 'error' => 'شناسه پرداخت ارسال نشده است']);
        exit;
    }
    $code = trim($_POST['code']);
    $changes = [];
    try {
        $stmt = $pdo->prepare("
        SELECT *
        FROM patients_payments
        WHERE payment_code = :code
          AND office_code = :office_code AND status != 'DELETED'
    ");
        $stmt->execute([
            ':code'        => $code,
            ':office_code' => $officeCode
        ]);
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)){
            $changes = json_decode($row['changes'], true);
        }
        $change['action'] = "DELETE";
        $change['user'] = $_SESSION['user_code'];
        $change['data'] = date('Y-m-d H:i:s');
        $changes[] = $change;
        $stmt = $pdo->prepare("
            UPDATE patients_payments
            SET status = 'DELETED', changes = :changes
            WHERE payment_code = :code
              AND office_code = :office_code
        ");
        $stmt->execute([
            ':changes'  => json_encode($changes),
            ':code'        => $code,
            ':office_code' => $officeCode
        ]);

        if ($stmt->rowCount()) {
            echo json_encode(['success' => true, 'message' => 'پرداختی با موفقیت حذف شد.']);
        } else {
            echo json_encode(['success' => false, 'error' => 'پرداختی برای حذف یافت نشد.']);
        }
    } catch (Exception $e) {
        echo json_encode(['success' => false, 'error' => 'خطای پایگاه داده: ' . $e->getMessage()]);
    }
}