<?php
// api/login.php

header('Content-Type: application/json');
session_start();
require_once 'config.php';
require_once "jdf.php"; // اتصال PDO + توابع رمزنگاری

$data = json_decode(file_get_contents('php://input'), true);
$username = $data['username'] ?? '';
$authHash = $data['auth_hash'] ?? '';
$_SESSION['auth_verified'] = false;
if (empty($username) || empty($authHash)) {
    if(isset($_POST['action']) && $_POST['action'] == 'verify_otp'){
        if($_POST['action'] == 'verify_otp'){
            if (session_status() === PHP_SESSION_NONE) {
                session_start();
            }

            if (empty($_SESSION['pending_phone'])) {
                echo json_encode(["success" => false, "error" => "نشست نامعتبر است. لطفا دوباره وارد شوید."]);
                exit;
            }

            $otp_input = trim($_POST['otp'] ?? '');
            if (!preg_match('/^\d{6}$/', $otp_input)) {
                echo json_encode(["success" => false, "error" => "کد تایید نامعتبر است."]);
                exit;
            }

            try {
                $phone = $_SESSION['pending_phone'];
                $phone_enc = encryptData($_SESSION['pending_phone']);
                $phone_hash = hashData($_SESSION['pending_phone']);
                $stmt = $pdo->prepare("SELECT otp_code_encrypted, expires_at 
                               FROM otp 
                               WHERE phone_hash = ? AND purpose = 'login' 
                               ORDER BY id DESC LIMIT 1");
                $stmt->execute([$phone_hash]);
                $otp_data = $stmt->fetch(PDO::FETCH_ASSOC);

                if (!$otp_data) {
                    echo json_encode(["success" => false, "error" => '']);
                    exit;
                }

                if (strtotime($otp_data['expires_at']) < time()) {
                    echo json_encode(["success" => false, "error" => "کد منقضی شده است."]);
                    exit;
                }

                if (decryptData($otp_data['otp_code_encrypted']) !== $otp_input) {
                    echo json_encode(["success" => false, "error" => decryptData($otp_data['otp_code_encrypted'])]);
                    exit;
                }
                $date = jdate('Y-m-d', time(), '', 'Asia/Tehran');
                $time = jdate('H:i:s', time(), '', 'Asia/Tehran');

                send_sms_5625($pdo,$pdo_lab,384492,['date'=>$date,'hour'=>$time],$phone,"DENTOPIN_OFFICE");
// ایجاد سشن ورود
                $stmt = $pdo->prepare("SELECT user_code FROM users WHERE phone_hash = ?");
                $stmt->execute([$phone_hash]);
                $user = $stmt->fetch(PDO::FETCH_ASSOC);

                $_SESSION['user_code'] = $user['user_code'];
                unset($_SESSION['pending_phone']);

// Always create remember-me cookie (mandatory)
                $token = bin2hex(random_bytes(32)); // raw token for cookie
                $token_hash = hash('sha256', $token);
                $expires_at = date('Y-m-d H:i:s', time() + (30 * 24 * 60 * 60)); // 30 days

// Remove any old remember tokens for this user to avoid multiple valid tokens
                $pdo->prepare("DELETE FROM remember_tokens WHERE user_code = ?")->execute([$user['user_code']]);

                $pdo->prepare("DELETE FROM otp WHERE phone_hash = ?")->execute([$phone_hash]);

// Store new token
                $pdo->prepare("INSERT INTO remember_tokens (user_code, token_hash, expires_at) VALUES (?, ?, ?)")
                    ->execute([$user['user_code'], $token_hash, $expires_at]);

// Set secure cookie
                setcookie(
                    'remember_token',
                    $token,
                    [
                        'expires' => time() + (30 * 24 * 60 * 60),
                        'path' => '/',
                        'secure' => isset($_SERVER['HTTPS']),
                        'httponly' => true,
                        'samesite' => 'Strict'
                    ]
                );

                echo json_encode(["success" => true]);

            } catch (Exception $e) {
                echo json_encode(["success" => false, "error" => $e->getMessage()]);
            }
        }
    }
    else{
        echo json_encode([
            'success' => false,
            'message' => 'اطلاعات ناقص است'
        ]);
        exit;
    }
}
else{
    try {
        $_SESSION['auth_verified'] = false;
        $stmt = $pdo->prepare('SELECT user_code, user_password,phone_encrypted,phone_hash,iv,salt,enc_code FROM users WHERE user_username = ?');
        $stmt->execute([$username]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($user && hash_equals($user['user_password'], $authHash)) {
            $_SESSION['auth_verified'] = true;
            $phone_enc1 = $user['phone_encrypted'];
            $phone_hash = $user['phone_hash'];
            $phone_enc = [
                'phone_encrypted' => decryptData($user['phone_encrypted'])
                ];
            $iv = $user['iv'];
            $salt = $user['salt'];
            $enc_code = $user['enc_code'];
            $tmp_office = get_decrypted_data($phone_enc,$iv,$salt,$enc_code);
            $phone = $tmp_office['phone_encrypted'];
            $otp_code = str_pad(random_int(0, 999999), 6, '0', STR_PAD_LEFT);
            $otp_enc = encryptData($otp_code);
            $expires_at = date('Y-m-d H:i:s', time() + 300);

            $stmt = $pdo->prepare("INSERT INTO otp (phone_hash,phone_encrypted, otp_code_encrypted, purpose, expires_at) 
                                   VALUES (?,?, ?, 'login', ?)");
            $stmt->execute([$phone_hash,$phone_enc1, $otp_enc, $expires_at]);

            // ذخیره شماره تلفن در سشن برای استفاده در otp.php
            $_SESSION['pending_phone'] = $phone;
            send_sms_5625($pdo,$pdo_lab,376083,['otp'=>$otp_code],$phone,"DENTOPIN_OFFICE");
            echo json_encode([
                'success' => true,
                'userId' => $user['user_code']
            ]);
        } else {
            echo json_encode([
                'success' => false,
                'message' => 'نام کاربری یا رمز عبور اشتباه است'
            ]);
        }

    } catch (PDOException $e) {
        error_log($e->getMessage());
        echo json_encode([
            'success' => false,
            'message' => 'خطای سرور'
        ]);
    }
}
?>