<?php
header('Content-Type: application/json; charset=utf-8');
require_once "config.php";
try {
    session_start();
    $action = $_POST['action'] ?? null;
    if (!$action) throw new Exception("No action provided.");

    switch ($action) {
        case 'load_orders':
            loadOrders($pdo,$pdo_lab);
            break;
        default:
            throw new Exception("Invalid action: " . htmlspecialchars($action));
    }
} catch (Throwable $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
    file_put_contents(__DIR__ . '/load_order_error.txt', $e->getMessage());

}

// === FUNCTIONS ===

function loadOrders($pdo,$pdo_lab) {
    $officeCode =  $_SESSION['user_code'] ?? null;
    $stmt = $pdo->prepare("SELECT * FROM lab_orders WHERE clinic_code = ?");
    $stmt->execute([$officeCode]);
    $orders = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        // Prepare dentists badges from JSON
        $lab_name = 'نامشخص';
        $patient_name = 'نامشخص';
        $dentist_name = 'نامشخص';
        $q = $pdo_lab->prepare("SELECT lab_name_encrypted FROM users WHERE lab_code = ?");
        $q->execute([$row['lab_code']]);
        while ($d = $q->fetch(PDO::FETCH_ASSOC)) {
            $lab_name = decryptData($d['lab_name_encrypted']);
        }

        if($row['manual_patient_name'] == "NA"){
            $q   = $pdo->prepare("SELECT patient_fullname_encrypted FROM patients WHERE patient_code = ?");
            $q->execute([$row['patient_code']]);
            while ($d = $q->fetch(PDO::FETCH_ASSOC)) {
                $patient_name = decryptData($d['patient_fullname_encrypted']);
            }
        }
        else{
            $patient_name = $row['manual_patient_name'];
        }

        if($row['manual_dentist_name'] == "NA"){
            $q   = $pdo->prepare("SELECT dentist_fullname_encrypted FROM dentists WHERE dentist_code = ?");
            $q->execute([$row['dentist_code']]);
            while ($d = $q->fetch(PDO::FETCH_ASSOC)) {
                $dentist_name = decryptData($d['dentist_fullname_encrypted']);
            }
        }
        else{
            $dentist_name = $row['manual_dentist_name'];
        }

        // Status badge
        $statusBadge = match($row['order_status']) {
            'NOTSENT_TO_LAB' => '<span class="badge bg-label-warning">کار به لابراتوار ارسال نشده</span>',
            'SENT_TO_LAB' => '<span class="badge bg-label-primary">به لابراتوار رسیده</span>',
            default => '<span class="badge bg-label-secondary">نامشخص</span>',
        };
        $orders[] = [
            'code'     => $row['order_code'],
            'number'     => $row['order_number'],
            'dentist_name' => $dentist_name,
            'lab_name' => $lab_name,
            'patient_name' => $patient_name,
            'date' => $row['order_date'],
            'status'   => $statusBadge,
            'actions'  => '<a href="order/' . $row['order_code'] . '" class="btn btn-sm btn-primary delete-unit">مشاهده</a>'
        ];
    }
    echo json_encode(['data' => $orders]);
    file_put_contents(__DIR__ . '/load_order_error.txt', json_encode(['data' => $orders]));
}

// Helper to check if JSON is valid
function json_validate($string) {
    if (!is_string($string)) return false;
    json_decode($string);
    return json_last_error() === JSON_ERROR_NONE;
}
