<?php
// logout.php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once "config.php"; // for $pdo connection

// 1. Remove remember token from DB if cookie exists
if (!empty($_COOKIE['remember_token'])) {
    $token_hash = hash('sha256', $_COOKIE['remember_token']);
    $stmt = $pdo->prepare("DELETE FROM remember_tokens WHERE token_hash = ?");
    $stmt->execute([$token_hash]);

    // Clear cookie in browser
    setcookie(
        'remember_token',
        '',
        [
            'expires' => time() - 3600, // Past date
            'path' => '/',
            'secure' => isset($_SERVER['HTTPS']),
            'httponly' => true,
            'samesite' => 'Strict'
        ]
    );
}

// 2. Clear all session data
$_SESSION = [];

// 3. Destroy session cookie if exists
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(
        session_name(),
        '',
        [
            'expires' => time() - 42000,
            'path' => $params['path'],
            'domain' => $params['domain'],
            'secure' => $params['secure'],
            'httponly' => $params['httponly'],
            'samesite' => 'Strict'
        ]
    );
}

// 4. Destroy the PHP session
session_destroy();

// 5. Redirect to login (or homepage)
header("Location: login.php");
exit;