<?php
session_start();
require 'auth21.php';
if (empty($_SESSION['user_code'])) {
    header("Location: login");
    exit;
}
$user = getUser($pdo);
if($user['account_status'] == "NOTSIGNEDUP"){
    header("Location: registration");
    exit;
}
?>
<!DOCTYPE html>
<html class="light-style layout-navbar-fixed layout-menu-fixed layout-compact" data-assets-path="../../assets/" data-template="vertical-menu-template-no-customizer" data-theme="theme-default" dir="rtl" lang="fa">

<head>
    <meta charset="UTF-8"/>
    <meta content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" name="viewport"/>
    <title>سوابق پزشکی</title>
    <meta content="" name="description"/>
    <!-- Favicon -->
    <link href="../../assets/img/favicon/favicon.ico" rel="icon" type="image/x-icon"/>
    <!-- Icons -->
    <link href="../../assets/vendor/fonts/fontawesome.css" rel="stylesheet"/>
    <link href="../../assets/vendor/fonts/tabler-icons.css" rel="stylesheet"/>
    <link href="../../assets/vendor/fonts/flag-icons.css" rel="stylesheet"/>
    <!-- Core CSS -->
    <link href="../../assets/vendor/css/rtl/core.css" rel="stylesheet"/>
    <link href="../../assets/vendor/css/rtl/theme-default.css" rel="stylesheet"/>
    <link href="../../assets/css/demo.css" rel="stylesheet"/>
    <!-- Vendors CSS -->
    <link href="../../assets/vendor/libs/node-waves/node-waves.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/typeahead-js/typeahead.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/select2/select2.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/@form-validation/form-validation.css" rel="stylesheet"/>
    <link rel="stylesheet" href="../../assets/vendor/libs/sweetalert2/sweetalert2.css" />

    <!-- Helpers -->
    <script src="../../assets/vendor/js/helpers.js"></script>
    <script src="../../assets/js/jquery-3.6.0.min.js"></script>
    <script src="../../assets/vendor/libs/sweetalert2/sweetalert2.js"></script>
    <script src="../../assets/js/config.js"></script>
    <link href="../../assets/css/rtl.css" rel="stylesheet"/>
</head>

<body>
<div class="layout-wrapper layout-content-navbar">
    <div class="layout-container">
        <?php require_once 'sidebar.php';?>
        <div class="layout-page">
            <?php require_once 'navbar.php';?>
            <div class="content-wrapper">
                <div class="container-xxl flex-grow-1 container-p-y">
                    <div class="card">
                        <div class="card-header border-bottom">
                            <h5 class="card-title mb-3">سوابق پزشکی</h5>
                            <button class="btn btn-secondary add-new btn-primary waves-effect waves-light" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasAddHistory">
                                <span><i class="ti ti-plus me-0 me-sm-1 ti-xs"></i>
                                <span class="d-none d-sm-inline-block">افزودن سابقه پزشکی</span></span>
                            </button>
                        </div>
                        <div class="card-datatable table-responsive">
                            <table class="datatables-histories table">
                                <thead class="border-top">
                                <tr>
                                    <th>عنوان</th>
                                    <th>نوع</th>
                                    <th>توضیحات</th>
                                    <th>هشدار</th>
                                    <th>عملیات</th>
                                </tr>
                                </thead>
                            </table>
                        </div>
                        <script>
                            $(document).ready(function () {
                                $('.datatables-histories').DataTable({
                                    processing: true,
                                    ajax: {
                                        url: 'functions/medical_histories_funcs.php',
                                        type: 'POST',
                                        data: { action: 'load_histories' },
                                        dataSrc: 'data'
                                    },
                                    columns: [
                                        { data: 'title' },
                                        { data: 'history_type' },
                                        { data: 'description' },
                                        { data: 'alert_flag', orderable: false, searchable: false },
                                        { data: 'actions', orderable: false, searchable: false }
                                    ],
                                    language: {
                                        url: '//cdn.datatables.net/plug-ins/1.13.4/i18n/fa.json'
                                    }
                                });
                            });
                            $(document).on('click', '.delete-history', function () {
                                const historyId = $(this).data('code');
                                Swal.fire({
                                    title: 'مطمئنی؟',
                                    text: 'این سابقه برای همیشه حذف خواهد شد!',
                                    icon: 'warning',
                                    showCancelButton: true,
                                    confirmButtonText: 'بله, حذف شود!',
                                    cancelButtonText: 'بازگشت',
                                    customClass: {
                                        confirmButton: 'btn btn-danger me-3 waves-effect waves-light',
                                        cancelButton: 'btn btn-label-secondary waves-effect waves-light'
                                    },
                                    buttonsStyling: false
                                }).then(function (result) {
                                    if (result.isConfirmed) {
                                        fetch('functions/medical_histories_funcs.php', {
                                            method: 'POST',
                                            body: new URLSearchParams({ action: 'delete_history', code: historyId })
                                        })
                                            .then(r => r.json())
                                            .then(data => {
                                                if (data.success) {
                                                    $('.datatables-histories').DataTable().ajax.reload();
                                                    Swal.fire({
                                                        icon: 'success',
                                                        title: 'حذف شد!',
                                                        text: data.message || 'سابقه با موفقیت حذف شد.',
                                                        confirmButtonText: 'باشه',
                                                        customClass: {
                                                            confirmButton: 'btn btn-success waves-effect waves-light'
                                                        }
                                                    });
                                                } else {
                                                    Swal.fire({
                                                        title: 'لغو شده',
                                                        text: data.error || 'خطایی در حذف رخ داد.',
                                                        confirmButtonText: 'باشه',
                                                        icon: 'error',
                                                        customClass: {
                                                            confirmButton: 'btn btn-success waves-effect waves-light'
                                                        }
                                                    });
                                                }
                                            })
                                            .catch(() => {
                                                Swal.fire({
                                                    title: 'خطا',
                                                    text: 'مشکل ارتباط با سرور',
                                                    confirmButtonText: 'باشه',
                                                    icon: 'error',
                                                    customClass: {
                                                        confirmButton: 'btn btn-success waves-effect waves-light'
                                                    }
                                                });
                                            });
                                    }
                                });
                            });
                        </script>
                        <div class="offcanvas offcanvas-end" id="offcanvasAddHistory">
                            <div class="offcanvas-header">
                                <h5 class="offcanvas-title">افزودن سابقه پزشکی</h5>
                                <button class="btn-close text-reset" data-bs-dismiss="offcanvas" type="button"></button>
                            </div>
                            <div class="offcanvas-body mx-0 flex-grow-0 pt-0 h-100">
                                <form id="addNewHistoryForm">
                                    <div class="mb-3">
                                        <label class="form-label" for="add-history-title">عنوان</label>
                                        <input class="form-control" id="add-history-title" name="add-history-title" type="text"/>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label" for="add-history-type">نوع</label>
                                        <select class="form-select" id="add-history-type" name="add-history-type">
                                            <option value="بیماری">بیماری</option>
                                            <option value="دارو">دارو</option>
                                            <option value="حساسیت">حساسیت</option>
                                            <option value="سابقه بستری">سابقه بستری</option>
                                            <option value="سابقه جراحی">سابقه جراحی</option>
                                            <option value="سایر">سایر</option>
                                        </select>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label" for="add-history-description">توضیحات</label>
                                        <textarea class="form-control" id="add-history-description" name="add-history-description"></textarea>
                                    </div>
                                    <div class="form-check mb-3">
                                        <input class="form-check-input" type="checkbox" id="add-history-alert" name="add-history-alert" value="1">
                                        <label class="form-check-label" for="add-history-alert">علامت هشدار</label>
                                    </div>
                                    <button id="addHistoryBtn" class="btn btn-primary me-sm-3 me-1 data-submit" type="button">افزودن</button>
                                    <button class="btn btn-label-secondary" data-bs-dismiss="offcanvas" type="reset">لغو</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <script>
                    document.getElementById('addHistoryBtn').addEventListener('click', function () {
                        const form = document.getElementById('addNewHistoryForm');
                        const formData = new FormData(form);
                        formData.append('action', 'add_history');

                        fetch('functions/medical_histories_funcs.php', {
                            method: 'POST',
                            body: formData
                        })
                            .then(r => r.text())
                            .then(text => {
                                console.log("RAW RESPONSE:", text);
                                return JSON.parse(text);
                            })
                            .then(data => {
                                if (data.success) {
                                    Swal.fire({
                                        icon: 'success',
                                        title: 'موفق!',
                                        text: data.message || 'سابقه با موفقیت اضافه شد.',
                                        confirmButtonText: 'باشه',
                                        customClass: {
                                            confirmButton: 'btn btn-success waves-effect waves-light'
                                        },
                                        buttonsStyling: false
                                    });

                                    $('.datatables-histories').DataTable().ajax.reload();
                                    form.reset();
                                } else {
                                    Swal.fire({
                                        icon: 'error',
                                        title: 'خطا',
                                        text: data.error || 'خطا در ذخیره سابقه',
                                        confirmButtonText: 'باشه',
                                        customClass: {
                                            confirmButton: 'btn btn-danger waves-effect waves-light'
                                        },
                                        buttonsStyling: false
                                    });
                                }
                            })
                            .catch(err => {
                                console.error(err);
                                Swal.fire({
                                    icon: 'error',
                                    title: 'خطای ارتباط',
                                    text: 'خطای ارتباط با سرور',
                                    confirmButtonText: 'باشه',
                                    customClass: {
                                        confirmButton: 'btn btn-danger waves-effect waves-light'
                                    },
                                    buttonsStyling: false
                                });
                            });
                    });

                    $(document).on('click', '.edit-history', function () {
                        const historyId = $(this).data('code');
                        fetch('functions/medical_histories_funcs.php', {
                            method: 'POST',
                            body: new URLSearchParams({ action: 'get_history', code: historyId })
                        })
                            .then(r => r.json())
                            .then(data => {
                                if (!data.success) {
                                    Swal.fire({
                                        icon: 'error',
                                        title: 'خطا',
                                        text: data.error || 'سابقه یافت نشد',
                                        confirmButtonText: 'باشه',
                                        customClass: { confirmButton: 'btn btn-danger waves-effect waves-light' },
                                        buttonsStyling: false
                                    });
                                    return;
                                }

                                const h = data.history;

                                Swal.fire({
                                    title: 'ویرایش سابقه',
                                    html: `
                                        <input id="swal-edit-title" class="swal2-input" placeholder="عنوان" value="${h.title || ''}">
                                        <select id="swal-edit-type" class="swal2-input mt-2">
                                            <option value="بیماری" ${h.history_type === 'بیماری' ? 'selected' : ''}>بیماری</option>
                                            <option value="دارو" ${h.history_type === 'دارو' ? 'selected' : ''}>دارو</option>
                                            <option value="حساسیت" ${h.history_type === 'حساسیت' ? 'selected' : ''}>حساسیت</option>
                                            <option value="سابقه بستری" ${h.history_type === 'سابقه بستری' ? 'selected' : ''}>سابقه بستری</option>
                                            <option value="سابقه جراحی" ${h.history_type === 'سابقه جراحی' ? 'selected' : ''}>سابقه جراحی</option>
                                            <option value="سایر" ${h.history_type === 'سایر' ? 'selected' : ''}>سایر</option>
                                        </select>
                                        <textarea id="swal-edit-description" class="swal2-input" placeholder="توضیحات">${h.description || ''}</textarea>
                                        <label><input type="checkbox" id="swal-edit-alert" ${h.alert_flag == 1 ? 'checked' : ''}> علامت هشدار</label>
                                    `,
                                    focusConfirm: false,
                                    showCancelButton: true,
                                    confirmButtonText: 'ذخیره تغییرات',
                                    cancelButtonText: 'لغو',
                                    customClass: {
                                        confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                                        cancelButton: 'btn btn-label-secondary waves-effect waves-light'
                                    },
                                    buttonsStyling: false,
                                    preConfirm: () => {
                                        return {
                                            code: historyId,
                                            title: document.getElementById('swal-edit-title').value.trim(),
                                            history_type: document.getElementById('swal-edit-type').value.trim(),
                                            description: document.getElementById('swal-edit-description').value.trim(),
                                            alert_flag: document.getElementById('swal-edit-alert').checked ? 1 : 0
                                        };
                                    }
                                }).then(result => {
                                    if (result.isConfirmed) {
                                        const fd = new FormData();
                                        fd.append('action', 'update_history');
                                        for (const key in result.value) {
                                            fd.append(key, result.value[key]);
                                        }
                                        fetch('functions/medical_histories_funcs.php', {
                                            method: 'POST',
                                            body: fd
                                        })
                                            .then(r => r.json())
                                            .then(update => {
                                                if (update.success) {
                                                    $('.datatables-histories').DataTable().ajax.reload();
                                                    Swal.fire({
                                                        icon: 'success',
                                                        title: 'موفق!',
                                                        text: update.message || 'اطلاعات با موفقیت بروزرسانی شد.',
                                                        confirmButtonText: 'باشه',
                                                        customClass: { confirmButton: 'btn btn-success waves-effect waves-light' },
                                                        buttonsStyling: false
                                                    });
                                                } else {
                                                    Swal.fire({
                                                        icon: 'error',
                                                        title: 'خطا',
                                                        text: update.error || 'بروزرسانی انجام نشد',
                                                        confirmButtonText: 'باشه',
                                                        customClass: { confirmButton: 'btn btn-danger waves-effect waves-light' },
                                                        buttonsStyling: false
                                                    });
                                                }
                                            })
                                            .catch(err => {
                                                console.error(err);
                                                Swal.fire({
                                                    icon: 'error',
                                                    title: 'خطا',
                                                    text: 'ارتباط با سرور برقرار نشد',
                                                    confirmButtonText: 'باشه',
                                                    customClass: { confirmButton: 'btn btn-danger waves-effect waves-light' },
                                                    buttonsStyling: false
                                                });
                                            });
                                    }
                                });
                            });
                    });
                </script>
                <footer class="content-footer footer bg-footer-theme">
                    <div class="container-xxl">
                        <div class="footer-container d-flex align-items-center justify-content-between py-2 flex-md-row flex-column">
                            <div>©
                                <script>document.write(new Date().getFullYear());</script>
                                , ارائه شده توسط <span class="text-danger byte-hover">بایت ‌مَستر</span> در سایت
                                <a class="fw-medium" href="#support" target="_blank">راستچین</a>
                            </div>
                            <div class="d-none d-lg-inline-block">
                                <a class="footer-link me-4" href="#support" target="_blank">لایسنس</a>
                                <a class="footer-link me-4" href="#support" target="_blank">قالب‌های بیشتر</a>
                                <a class="footer-link me-4" href="https://demos.pixinvent.com/vuexy-html-admin-template/documentation/" target="_blank">مستندات</a>
                                <a class="footer-link d-none d-sm-inline-block" href="#support-theme" target="_blank">پشتیبانی</a>
                            </div>
                        </div>
                    </div>
                </footer>
                <div class="content-backdrop fade"></div>
            </div>
        </div>
    </div>
    <div class="layout-overlay layout-menu-toggle"></div>
    <div class="drag-target"></div>
</div>
<script src="../../assets/vendor/libs/jquery/jquery.js"></script>
<script src="../../assets/vendor/libs/popper/popper.js"></script>
<script src="../../assets/vendor/js/bootstrap.js"></script>
<script src="../../assets/vendor/libs/node-waves/node-waves.js"></script>
<script src="../../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="../../assets/vendor/libs/hammer/hammer.js"></script>
<script src="../../assets/vendor/libs/i18n/i18n.js"></script>
<script src="../../assets/vendor/libs/typeahead-js/typeahead.js"></script>
<script src="../../assets/vendor/js/menu.js"></script>
<script src="../../assets/vendor/libs/moment/moment.js"></script>
<script src="../../assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js"></script>
<script src="../../assets/vendor/libs/datatables-bs5/i18n/fa.js"></script>
<script src="../../assets/vendor/libs/select2/select2.js"></script>
<script src="../../assets/vendor/libs/select2/i18n/fa.js"></script>
<script src="../../assets/vendor/libs/@form-validation/popular.js"></script>
<script src="../../assets/vendor/libs/@form-validation/bootstrap5.js"></script>
<script src="../../assets/vendor/libs/@form-validation/auto-focus.js"></script>
<script src="../../assets/vendor/libs/cleavejs/cleave.js"></script>
<script src="../../assets/vendor/libs/cleavejs/cleave-phone.js"></script>
<script src="../../assets/js/main.js"></script>
</body>
</html>
