<?php
session_start();
require 'auth21.php';
if (empty($_SESSION['user_code'])) {
    $path = $_SERVER['REQUEST_URI'];
    $afterMain = explode('main/', $path, 2)[1] ?? '';
    $afterMainEncoded = urlencode($afterMain);
    $redirectUrl = $afterMainEncoded;
    header("Location: " . ROOT . 'login?redirect=' . $redirectUrl);
    exit;
}
$user = getUser($pdo);
if($user['account_status'] == "NOTSIGNEDUP"){
    header("Location: registration");
    exit;
}
$officeCode = $_SESSION['user_code'] ?? null;
$order_code = URL(1);
$stmt = $pdo->prepare("
    SELECT *
    FROM lab_orders
    WHERE clinic_code = :office_code
    AND order_code = :order_code
");
$stmt->execute([':office_code' => $officeCode, ':order_code' => $order_code]);
$order = $stmt->fetch(PDO::FETCH_ASSOC);
$lab_code = $order['lab_code'];
$service_code = $order['service_code'];
$dentist_code = $order['dentist_code'];

$patient_code = $order['patient_code'];
if($patient_code === "MANUAL"){
    $patient_name = $order['manual_patient_name'];
}
else{
    $stmt = $pdo->prepare("SELECT * FROM patients WHERE office_code = ? AND patient_code = ?");
    $stmt->execute([$officeCode,$patient_code]);
    $patient = $stmt->fetch(PDO::FETCH_ASSOC);
    $patient_name = decryptData($patient['patient_fullname_encrypted']);
}

if($dentist_code === "MANUAL"){
    $dentist_name = $order['manual_dentist_name'];
}
else{
// Get dentists (assuming you have a dentists table)
    $stmt = $pdo->prepare("SELECT dentist_code, dentist_fullname_encrypted FROM dentists WHERE office_code = ? AND dentist_code = ?");
    $stmt->execute([$officeCode,$dentist_code]);
    $dentist = $stmt->fetch(PDO::FETCH_ASSOC);
    $dentist_name = decryptData($dentist['dentist_fullname_encrypted']);
}
$stmt = $pdo_lab->prepare("
        SELECT lab_name_encrypted,full_name_encrypted,phone_encrypted,address_encrypted
        FROM users
        WHERE lab_code = :lab_code
    ");
$stmt->execute([':lab_code' => $lab_code]);
$lab = $stmt->fetch(PDO::FETCH_ASSOC);
$tariffs = [];
$stmt = $pdo->prepare("
    SELECT *
    FROM tariffs
    WHERE office_code = :office_code AND for_type = 'services' AND status != 'DELETED'
");
$stmt->execute([':office_code' => $officeCode]);
$tariffs = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<?php
$stmt = $pdo_lab->prepare("
        SELECT service_code, service_title, service_category_code
        FROM services
        WHERE lab_code = :lab_code AND service_code = :service_code
    ");
$stmt->execute([':lab_code' => $lab_code,':service_code' => $service_code]);
$service = $stmt->fetch(PDO::FETCH_ASSOC);
$service_category_code = $service['service_category_code'];
?>
<?php
$stmt = $pdo_lab->prepare("
        SELECT *
        FROM service_categories
        WHERE lab_code = :lab_code AND service_category_code = :service_category_code
    ");
$stmt->execute([':lab_code' => $lab_code,':service_category_code' => $service_category_code]);
$service_category = $stmt->fetch(PDO::FETCH_ASSOC);
?>
<?php
$order_custom_fields = json_decode($order['custom_fields']);
$stmt = $pdo_lab->prepare("
        SELECT *
        FROM services_custom_fields
        WHERE lab_code = :lab_code
    ");
$stmt->execute([':lab_code' => $lab_code]);
$temp_custom_fields = $stmt->fetchAll(PDO::FETCH_ASSOC);
$custom_fields = [];
foreach ($temp_custom_fields as $temp_custom_field) {
    $custom_fields[$temp_custom_field['cf_code']] = $temp_custom_field;
}
?>
<!DOCTYPE html>
<html class="light-style layout-navbar-fixed layout-menu-fixed layout-compact" data-assets-path="../../../assets/" data-template="vertical-menu-template-no-customizer" data-theme="theme-default" dir="rtl" lang="fa">

<head>
    <meta charset="UTF-8"/>
    <meta content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" name="viewport"/>
    <title>نمایش کاربر - حساب کاربری | Vuexy - قالب مدیریت بوت استرپ</title>
    <meta content="" name="description"/>
    <!-- Favicon -->
    <link href="../../../assets/img/favicon/favicon.ico" rel="icon" type="image/x-icon"/>
    <!-- Icons -->
    <link href="../../../assets/vendor/fonts/fontawesome.css" rel="stylesheet"/>
    <link href="../../../assets/vendor/fonts/tabler-icons.css" rel="stylesheet"/>
    <link href="../../../assets/vendor/fonts/flag-icons.css" rel="stylesheet"/>
    <!-- Core CSS -->
    <link href="../../../assets/vendor/css/rtl/core.css" rel="stylesheet"/>
    <link href="../../../assets/vendor/css/rtl/theme-default.css" rel="stylesheet"/>
    <link href="../../../assets/css/demo.css" rel="stylesheet"/>
    <!-- Vendors CSS -->
    <link href="../../../assets/vendor/libs/node-waves/node-waves.css" rel="stylesheet"/>
    <link href="../../../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" rel="stylesheet"/>
    <link href="../../../assets/vendor/libs/typeahead-js/typeahead.css" rel="stylesheet"/>
    <link href="../../../assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css" rel="stylesheet"/>
    <link href="../../../assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css" rel="stylesheet"/>
    <link href="../../../assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.css" rel="stylesheet"/>
    <link href="../../../assets/vendor/libs/animate-css/animate.css" rel="stylesheet"/>
    <link href="../../../assets/vendor/libs/sweetalert2/sweetalert2.css" rel="stylesheet"/>
    <link href="../../../assets/vendor/libs/select2/select2.css" rel="stylesheet"/>
    <link href="../../../assets/vendor/libs/@form-validation/form-validation.css" rel="stylesheet"/>
    <!-- Page CSS -->
    <link href="../../../assets/vendor/css/pages/page-user-view.css" rel="stylesheet"/>
    <!-- Helpers -->
    <script src="../../../assets/vendor/js/helpers.js"></script>

    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="../../../assets/js/config.js"></script>
    <!-- Better experience of RTL -->
    <link href="../../../assets/css/rtl.css" rel="stylesheet"/>
    <script src="../../../assets/vendor/libs/jquery/jquery.js"></script>

</head>

<body>
<!-- Layout wrapper -->
<div class="layout-wrapper layout-content-navbar">
    <div class="layout-container">
        <!-- Menu -->
        <?php require_once 'sidebar.php';?>
        <!-- / Menu -->
        <!-- Layout container -->
        <div class="layout-page">
            <!-- Navbar -->
            <?php require_once 'navbar.php';?>
            <!-- / Navbar -->
            <!-- Content wrapper -->
            <div class="content-wrapper">
                <!-- Content -->
                <div class="container-xxl flex-grow-1 container-p-y">
                    <h4 class="py-3 mb-2">
                        <span class="text-muted fw-light">سفارشات لابراتوار /</span>
                        جزئیات سفارش
                    </h4>
                    <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-3">
                        <div class="d-flex flex-column justify-content-center gap-2 gap-sm-0">
                            <h5 class="mb-1 mt-3 d-flex flex-wrap gap-2 align-items-end">
                                سفارش شماره <?=$order['order_number']?>
                                <?php
                                $statusMap = [
                                        'PAID'             => ['text' => 'پرداخت شده',          'class' => 'bg-label-success'],
                                        'UNPAID'           => ['text' => 'در انتظار پرداخت',     'class' => 'bg-label-warning'],
                                        'REJECTED'         => ['text' => 'رد شده',               'class' => 'bg-label-danger'],
                                        'CANCELLED'        => ['text' => 'لغو شده',              'class' => 'bg-label-dark'],
                                        'PROCESSING'       => ['text' => 'در حال انجام',         'class' => 'bg-label-info'],
                                        'SENT_TO_LAB'      => ['text' => 'ارسال به لابراتوار',   'class' => 'bg-label-primary'],
                                        'NOTSENT_TO_LAB'   => ['text' => 'ارسال نشده',           'class' => 'bg-label-secondary'],
                                        'DONE'             => ['text' => 'انجام شده',            'class' => 'bg-label-success'],
                                        'NEED_EDITS'       => ['text' => 'نیاز به اصلاح',        'class' => 'bg-label-warning'],
                                        'SENDING_TO_OFFICE'       => ['text' => 'در حال ارسال به مطب',        'class' => 'bg-label-primary'],
                                ];
                                // دریافت وضعیت فعلی
                                $status = $order['order_status'] ?? '';
                                $text   = $statusMap[$status]['text']  ?? 'نامشخص';
                                $class  = $statusMap[$status]['class'] ?? 'text-muted';
                                ?>
                                <span class="badge bg-label <?= htmlspecialchars($class) ?>">
    <?= htmlspecialchars($text) ?>
</span>
                            </h5>
                            <?php
                            $gDateTime = $order['date'];
                            list($date, $time) = explode(' ', $gDateTime);
                            list($gy, $gm, $gd) = explode('-', $date);
                            list($jy, $jm, $jd) = gregorian_to_jalali($gy, $gm, $gd);

                            $monthName = jdate_words(array('mm' => $jm), ' ');
                            $persianTime = tr_num(date('H:i', strtotime($time)), 'fa'); // use H:i for 24-hour format
                            $persianDay = tr_num($jd, 'fa');
                            $persianYear = tr_num($jy, 'fa');
                            ?>
                            <p class="text-body"><?=htmlspecialchars("{$persianDay} {$monthName} {$persianYear}") . ' - ' . htmlspecialchars("{$persianTime}")?></p>

                        </div>
                        <div class="d-flex align-content-center flex-wrap gap-2">
                            <button class="btn btn-label-primary delete-order">صورتحساب این سفارش</button>
                        </div>
                    </div>
                    <!-- Order Details Table -->
                    <div class="row">
                        <div class="col-12 col-lg-8">
                            <div class="card mb-4">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-12 col-md-6 col-lg-4">
                                            <h5>نام بیمار : </h5>
                                            <p><?=htmlspecialchars($patient_name)?></p>
                                        </div>
                                        <div class="col-12 col-md-6 col-lg-4">
                                            <h5>نام لابراتوار : </h5>
                                            <p><?=htmlspecialchars(decryptData($lab['lab_name_encrypted']))?></p>
                                        </div>
                                        <div class="col-12 col-md-6 col-lg-4">
                                            <h5>نام مسئول لابراتوار : </h5>
                                            <p><?=htmlspecialchars(decryptData($lab['full_name_encrypted']))?></p>
                                        </div>
                                        <div class="col-12 col-md-6 col-lg-4">
                                            <h5>نام دندانپزشک : </h5>
                                            <p><?=htmlspecialchars($dentist_name)?></p>
                                        </div>
                                        <div class="col-12 col-md-6 col-lg-4">
                                            <h5>دسته بندی خدمت : </h5>
                                            <p><?=htmlspecialchars($service_category['category_title'])?></p>
                                        </div>
                                        <div class="col-12 col-md-6 col-lg-4">
                                            <h5>خدمت : </h5>
                                            <p><?=htmlspecialchars($service['service_title'])?></p>
                                        </div>
                                        <div class="col-12 col-md-6 col-lg-4">
                                            <h5>وضعیت سفارش : </h5>
                                            <?php
                                            $statusMap = [
                                                    'SENT_TO_LAB'      => ['text' => 'ارسال به لابراتوار',  'color' => '#007bff'],  // آبی
                                                    'NOTSENT_TO_LAB'   => ['text' => 'ارسال نشده به لابراتوار', 'color' => '#6c757d'], // خاکستری
                                                    'SEEN_BY_LAB'      => ['text' => 'مشاهده توسط لابراتوار', 'color' => '#17a2b8'], // فیروزه‌ای
                                                    'CONFIRMED_BY_LAB' => ['text' => 'تأیید توسط لابراتوار',  'color' => '#28a745'], // سبز
                                                    'PROCESSING'       => ['text' => 'در حال انجام',          'color' => '#ffc107'], // زرد
                                                    'DONE'             => ['text' => 'انجام شده',             'color' => '#198754'], // سبز تیره
                                                    'REJECTED'         => ['text' => 'رد شده',                'color' => '#dc3545'], // قرمز
                                                    'DELETED'          => ['text' => 'حذف شده',               'color' => '#343a40'], // خاکستری تیره
                                                    'NEED_EDITS'       => ['text' => 'نیاز به اصلاح',         'color' => '#fd7e14'], // نارنجی
                                            ];

                                            // دریافت وضعیت فعلی
                                            $status   = $order['order_status'] ?? '';
                                            $text     = $statusMap[$status]['text']  ?? 'نامشخص';
                                            $color    = $statusMap[$status]['color'] ?? '#000';
                                            ?>
                                            <p style="color: <?= htmlspecialchars($color) ?>;">
    <?= htmlspecialchars($text) ?>
</p>
                                        </div>
                                        <div class="col-12 col-md-6 col-lg-4">
                                            <h5>وضعیت کار : </h5>
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <h5>توضیحات سفارش : </h5>
                                            <p><?=htmlspecialchars($order['note'] ?? '------')?></p>
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <h5>دندانها:</h5>
                                            <?php
                                            $teeth = generateTeethChartHtml($order['order_teeth'],$order['order_dentition']);
                                            echo $teeth;
                                            ?>
                                        </div>
                                        <hr>
                                        <div class="vr"></div>

                                        <div class="col-12 col-md-6">
                                            <h5>فیلدهای سفارشی:</h5>
                                            <?php
                                            foreach ($order_custom_fields as $key => $value) {
                                                ?>
                                                    <p><span style="font-weight: bold"><?=htmlspecialchars($custom_fields[$key]['cf_title'])?></span> : <?=htmlspecialchars($value)?></p>
                                            <?php
                                            }
                                            ?>
                                        </div>
                                        <div class="vr"></div>
                                        <div class="col-12 col-md-6 col-lg-4">
                                            <h5>فایل ها : </h5>
                                            <?php
                                            if($order['uploaded_file_code'] === "" || $order['uploaded_file_code'] == NULL || $order['uploaded_file_code'] == "[]"){
                                                ?>
                                                <p class="text-danger">فایلی برای این سفارش آپلود نشده</p>
                                                <?php
                                            }
                                            else{
                                                $uploadedFiles = json_decode($order['uploaded_file_code'], true);
                                                foreach($uploadedFiles as $uploadedFile){
                                                    $stmt = $pdo->prepare("UPDATE temp_download SET active = 0 WHERE file_code = ? AND user_code = ?");
                                                    $stmt->execute([$uploadedFile,$officeCode]);
                                                    $temp_code = uniqid("TMP_") . '_' .  substr(hash('sha256', $officeCode), 0, 40) . '_' . rand(100000000, 999999999);
                                                    $stmt = $pdo->prepare("
    INSERT INTO temp_download (temp_code, file_code, user_code, expire_date, date)
    VALUES (:temp_code, :file_code, :user_code, DATE_ADD(NOW(6), INTERVAL 30 MINUTE), NOW(6))
");
                                                    $stmt->execute([
                                                            ':temp_code' => $temp_code,
                                                            ':file_code' => $uploadedFile,
                                                            ':user_code' => $officeCode
                                                    ]);
                                                    $stmt = $pdo->prepare("SELECT url, file_extension, original_name 
                           FROM uploaded_files 
                           WHERE file_code = :code AND user_code LIMIT 1");
                                                    $stmt->bindParam(':code', $uploadedFile, PDO::PARAM_STR);
                                                    $stmt->execute();
                                                    $file = $stmt->fetch(PDO::FETCH_ASSOC);
                                                    ?>
                                                    <p><?=htmlspecialchars($file['original_name'])?> - <a href="<?=ROOT?>download_files.php?c=<?=$temp_code?>" target="_blank">دانلود</a></p>
                                                    <hr>
                                                    <?php
                                                }
                                                ?>
                                                <?php
                                            }
                                            ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12 col-lg-4">
                            <div class="card mb-4">
                                <div class="card-header">
                                    <h6 class="card-title m-0">اطلاعات لابراتوار</h6>
                                </div>
                                <div class="card-body">
                                    <div class="d-flex justify-content-start align-items-center mb-4">
                                        <div class="d-flex flex-column">
                                            <a class="text-body text-nowrap" href="app-user-view-account.html">
                                                <h6 class="mb-0"><?=htmlspecialchars(decryptData($lab['lab_name_encrypted']))?></h6>
                                            </a>
                                        </div>
                                    </div>
                                    <a href="#" class="d-flex justify-content-start align-items-center mb-4">
                                        <span class="avatar rounded-circle bg-label-success me-2 d-flex align-items-center justify-content-center">
                                            <i class="ti ti-phone ti-sm"></i>
                                        </span>
                                        <h6 class="text-body text-nowrap mb-0">تماس با لابراتوار</h6>
                                    </a>
                                    <div class="d-flex justify-content-between">
                                        <h6>اطلاعات تماس</h6>
                                    </div>
                                    <p class="mb-0">تلفن :
                                        <bdi><?=htmlspecialchars(decryptData($lab['phone_encrypted']))?></bdi>
                                    </p>
                                </div>
                            </div>
                            <div class="card mb-4">
                                <div class="card-header d-flex justify-content-between">
                                    <h6 class="card-title m-0">آدرس لابراتوار</h6>
                                    <h6 class="m-0">
                                        <button class="btn btn-primary">درخواست پیک</button>
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <p class="mb-0">
                                        <?=htmlspecialchars(decryptData($lab['address_encrypted']) ?? '-------')?>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Edit User Modal -->
                    <div aria-hidden="true" class="modal fade" id="editUser" tabindex="-1">
                        <div class="modal-dialog modal-lg modal-simple modal-edit-user">
                            <div class="modal-content p-3 p-md-5">
                                <div class="modal-body">
                                    <button aria-label="بستن" class="btn-close" data-bs-dismiss="modal" type="button"></button>
                                    <div class="text-center mb-4">
                                        <h3 class="mb-2">ویرایش اطلاعات کاربر</h3>
                                        <p class="text-muted">به روزرسانی اطلاعات کاربر یک ممیزی حریم خصوصی دریافت می کند.</p>
                                    </div>
                                    <form class="row g-3" id="editUserForm" onsubmit="return false">
                                        <div class="col-12 col-md-6">
                                            <label class="form-label" for="modalEditUserFirstName">نام کوچک</label>
                                            <input class="form-control" id="modalEditUserFirstName" name="modalEditUserFirstName" placeholder="امیر" type="text"/>
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <label class="form-label" for="modalEditUserLastName">نام خانوادگی</label>
                                            <input class="form-control" id="modalEditUserLastName" name="modalEditUserLastName" placeholder="مقصودلو" type="text"/>
                                        </div>
                                        <div class="col-12">
                                            <label class="form-label" for="modalEditUserName">نام کاربری</label>
                                            <input class="form-control" id="modalEditUserName" name="modalEditUserName" placeholder="john.doe.007" type="text"/>
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <label class="form-label" for="modalEditUserEmail">ایمیل</label>
                                            <input class="form-control" id="modalEditUserEmail" name="modalEditUserEmail" placeholder="example@domain.com" type="text"/>
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <label class="form-label" for="modalEditUserStatus">وضعیت</label>
                                            <select aria-label="نمونه انتخاب پیش فرض" class="select2 form-select" id="modalEditUserStatus" name="modalEditUserStatus">
                                                <option selected>وضعیت</option>
                                                <option value="1">فعال</option>
                                                <option value="2">غیر فعال</option>
                                                <option value="3">معلق</option>
                                            </select>
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <label class="form-label" for="modalEditTaxID">شناسه مالیاتی</label>
                                            <input class="form-control modal-edit-tax-id" id="modalEditTaxID" name="modalEditTaxID" placeholder="123 456 7890" type="text"/>
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <label class="form-label" for="modalEditUserPhone">شماره تلفن</label>
                                            <div class="input-group">
                                                <span class="input-group-text">US (+1)</span>
                                                <input class="form-control phone-number-mask" id="modalEditUserPhone" name="modalEditUserPhone" placeholder="202 555 0111" type="text"/>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <label class="form-label" for="modalEditUserLanguage">زبان</label>
                                            <select class="select2 form-select" id="modalEditUserLanguage" multiple name="modalEditUserLanguage">
                                                <option value="">انتخاب کنید</option>
                                                <option selected value="english">انگلیسی</option>
                                                <option value="spanish">اسپانیایی</option>
                                                <option value="french">فرانسوی</option>
                                                <option value="german">آلمانی</option>
                                                <option value="dutch">هلندی</option>
                                                <option value="hebrew">عبری</option>
                                                <option value="sanskrit">سانسکریت</option>
                                                <option value="hindi">هندی</option>
                                            </select>
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <label class="form-label" for="modalEditUserCountry">کشور</label>
                                            <select class="select2 form-select" data-allow-clear="true" id="modalEditUserCountry" name="modalEditUserCountry">
                                                <option value="">انتخاب کنید</option>
                                                <option value="Australia">استرالیا</option>
                                                <option value="Bangladesh">بنگلادش</option>
                                                <option value="Belarus">بلاروس</option>
                                                <option value="Brazil">برزیل</option>
                                                <option value="Canada">کانادا</option>
                                                <option value="China">چین</option>
                                                <option value="France">فرانسه</option>
                                                <option value="Germany">آلمان</option>
                                                <option value="India">هندوستان</option>
                                                <option value="Indonesia">اندونزی</option>
                                                <option value="Israel">اسرائيل</option>
                                                <option value="Italy">ایتالیا</option>
                                                <option value="Japan">ژاپن</option>
                                                <option value="Korea">جمهوری کره</option>
                                                <option value="Mexico">مکزیک</option>
                                                <option value="Philippines">فیلیپین</option>
                                                <option value="Russia">فدراسیون روسیه</option>
                                                <option value="South Africa">آفریقای جنوبی</option>
                                                <option value="Thailand">تایلند</option>
                                                <option value="Turkey">ترکیه</option>
                                                <option value="Ukraine">اوکراین</option>
                                                <option value="United Arab Emirates">امارات متحده عربی</option>
                                                <option value="United Kingdom">انگلستان</option>
                                                <option value="United States">ایالات متحده</option>
                                            </select>
                                        </div>
                                        <div class="col-12">
                                            <label class="switch">
                                                <input class="switch-input" type="checkbox"/>
                                                <span class="switch-toggle-slider">
                                                    <span class="switch-on"></span>
                                                    <span class="switch-off"></span>
                                                </span>
                                                <span class="switch-label">به عنوان آدرس صورتحساب استفاده شود؟</span>
                                            </label>
                                        </div>
                                        <div class="col-12 text-center">
                                            <button class="btn btn-primary me-sm-3 me-1" type="submit">ارسال</button>
                                            <button aria-label="بستن" class="btn btn-label-secondary" data-bs-dismiss="modal" type="reset"> لغو</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--/ Edit User Modal -->
                    <!-- Add New Address Modal -->
                    <div aria-hidden="true" class="modal fade" id="addNewAddress" tabindex="-1">
                        <div class="modal-dialog modal-lg modal-simple modal-add-new-address">
                            <div class="modal-content p-3 p-md-5">
                                <div class="modal-body">
                                    <button aria-label="بستن" class="btn-close" data-bs-dismiss="modal" type="button"></button>
                                    <div class="text-center mb-4">
                                        <h3 class="address-title mb-2">اضافه کردن آدرس جدید</h3>
                                        <p class="text-muted address-subtitle">آدرس جدید برای تحویل سریع اضافه کنید</p>
                                    </div>
                                    <form class="row g-3" id="addNewAddressForm" onsubmit="return false">
                                        <div class="col-12">
                                            <div class="row">
                                                <div class="col-md mb-md-0 mb-3">
                                                    <div class="form-check custom-option custom-option-icon">
                                                        <label class="form-check-label custom-option-content" for="customRadioHome">
                                                            <span class="custom-option-body">
                                                                <svg fill="none" height="40" viewBox="0 0 41 40" width="41" xmlns="http://www.w3.org/2000/svg">
                                                                    <path d="M24.25 33.75V23.75H16.75V33.75H6.75002V18.0469C6.7491 17.8733 6.78481 17.7015 6.85482 17.5426C6.92482 17.3838 7.02754 17.2415 7.15627 17.125L19.6563 5.76562C19.8841 5.5559 20.1825 5.43948 20.4922 5.43948C20.8019 5.43948 21.1003 5.5559 21.3281 5.76562L33.8438 17.125C33.9696 17.2438 34.0703 17.3866 34.1401 17.5449C34.2098 17.7032 34.2472 17.8739 34.25 18.0469V33.75H24.25Z" fill="currentColor" opacity="0.2"/>
                                                                    <path d="M33.25 33.75C33.25 34.3023 33.6977 34.75 34.25 34.75C34.8023 34.75 35.25 34.3023 35.25 33.75H33.25ZM34.25 18.0469H35.25C35.25 18.0415 35.25 18.0361 35.2499 18.0307L34.25 18.0469ZM33.8437 17.125L34.5304 16.398C34.5256 16.3934 34.5207 16.389 34.5158 16.3845L33.8437 17.125ZM21.3281 5.76562L20.6509 6.50143L20.656 6.50611L21.3281 5.76562ZM19.6562 5.76562L20.3288 6.5057L20.3335 6.50141L19.6562 5.76562ZM7.15625 17.125L7.82712 17.8666L7.82878 17.8651L7.15625 17.125ZM6.75 18.0469H7.75001L7.74999 18.0416L6.75 18.0469ZM5.75 33.75C5.75 34.3023 6.19772 34.75 6.75 34.75C7.30228 34.75 7.75 34.3023 7.75 33.75H5.75ZM3 32.75C2.44772 32.75 2 33.1977 2 33.75C2 34.3023 2.44772 34.75 3 34.75V32.75ZM38 34.75C38.5523 34.75 39 34.3023 39 33.75C39 33.1977 38.5523 32.75 38 32.75V34.75ZM23.25 33.75C23.25 34.3023 23.6977 34.75 24.25 34.75C24.8023 34.75 25.25 34.3023 25.25 33.75H23.25ZM15.75 33.75C15.75 34.3023 16.1977 34.75 16.75 34.75C17.3023 34.75 17.75 34.3023 17.75 33.75H15.75ZM35.25 33.75V18.0469H33.25V33.75H35.25ZM35.2499 18.0307C35.2449 17.7243 35.1787 17.422 35.0551 17.1416L33.225 17.9481C33.2409 17.9844 33.2495 18.0235 33.2501 18.0631L35.2499 18.0307ZM35.0551 17.1416C34.9316 16.8612 34.7531 16.6084 34.5304 16.398L33.1571 17.852C33.1859 17.8792 33.209 17.9119 33.225 17.9481L35.0551 17.1416ZM34.5158 16.3845L22.0002 5.02514L20.656 6.50611L33.1717 17.8655L34.5158 16.3845ZM22.0053 5.02984C21.5929 4.6502 21.0528 4.43948 20.4922 4.43948V6.43948C20.551 6.43948 20.6076 6.46159 20.6509 6.50141L22.0053 5.02984ZM20.4922 4.43948C19.9316 4.43948 19.3915 4.6502 18.979 5.02984L20.3335 6.50141C20.3767 6.46159 20.4334 6.43948 20.4922 6.43948V4.43948ZM18.9837 5.02556L6.48371 16.3849L7.82878 17.8651L20.3288 6.50569L18.9837 5.02556ZM6.48538 16.3834C6.25236 16.5942 6.06642 16.8518 5.93971 17.1393L7.76988 17.9459C7.78318 17.9157 7.80268 17.8887 7.82712 17.8666L6.48538 16.3834ZM5.93971 17.1393C5.813 17.4269 5.74836 17.7379 5.75001 18.0521L7.74999 18.0416C7.74981 18.0087 7.75659 17.976 7.76988 17.9459L5.93971 17.1393ZM5.75 18.0469V33.75H7.75V18.0469H5.75ZM3 34.75H38V32.75H3V34.75ZM25.25 33.75V25H23.25V33.75H25.25ZM25.25 25C25.25 24.4033 25.013 23.831 24.591 23.409L23.1768 24.8232C23.2237 24.8701 23.25 24.9337 23.25 25H25.25ZM24.591 23.409C24.169 22.987 23.5967 22.75 23 22.75V24.75C23.0663 24.75 23.1299 24.7763 23.1768 24.8232L24.591 23.409ZM23 22.75H18V24.75H23V22.75ZM18 22.75C17.4033 22.75 16.831 22.9871 16.409 23.409L17.8232 24.8232C17.8701 24.7763 17.9337 24.75 18 24.75V22.75ZM16.409 23.409C15.9871 23.831 15.75 24.4033 15.75 25H17.75C17.75 24.9337 17.7763 24.8701 17.8232 24.8232L16.409 23.409ZM15.75 25V33.75H17.75V25H15.75Z" fill="currentColor"/>
                                                                </svg>
                                                                زمان تحویل
                                                                <span class="custom-option-title">درب منزل</span>
                                                                <small> (9 صبح تا 9 شب)</small>
                                                            </span>
                                                            <input checked class="form-check-input" id="customRadioHome" name="customRadioIcon" type="radio" value=""/>
                                                        </label>
                                                    </div>
                                                </div>
                                                <div class="col-md mb-md-0 mb-3">
                                                    <div class="form-check custom-option custom-option-icon">
                                                        <label class="form-check-label custom-option-content" for="customRadioOffice">
                                                            <span class="custom-option-body">
                                                                <svg fill="none" height="40" viewBox="0 0 41 40" width="41" xmlns="http://www.w3.org/2000/svg">
                                                                    <path d="M22.75 33.75V6.25C22.75 5.91848 22.6183 5.60054 22.3839 5.36612C22.1495 5.1317 21.8315 5 21.5 5H6.5C6.16848 5 5.85054 5.1317 5.61612 5.36612C5.3817 5.60054 5.25 5.91848 5.25 6.25V33.75" fill="currentColor" fill-opacity="0.2"/>
                                                                    <path d="M2.75 32.75C2.19772 32.75 1.75 33.1977 1.75 33.75C1.75 34.3023 2.19772 34.75 2.75 34.75V32.75ZM37.75 34.75C38.3023 34.75 38.75 34.3023 38.75 33.75C38.75 33.1977 38.3023 32.75 37.75 32.75V34.75ZM21.75 33.75C21.75 34.3023 22.1977 34.75 22.75 34.75C23.3023 34.75 23.75 34.3023 23.75 33.75H21.75ZM21.5 5V4V5ZM5.25 6.25H4.25H5.25ZM4.25 33.75C4.25 34.3023 4.69772 34.75 5.25 34.75C5.80228 34.75 6.25 34.3023 6.25 33.75H4.25ZM34.25 33.75C34.25 34.3023 34.6977 34.75 35.25 34.75C35.8023 34.75 36.25 34.3023 36.25 33.75H34.25ZM22.75 14C22.1977 14 21.75 14.4477 21.75 15C21.75 15.5523 22.1977 16 22.75 16V14ZM10.25 10.25C9.69772 10.25 9.25 10.6977 9.25 11.25C9.25 11.8023 9.69772 12.25 10.25 12.25V10.25ZM15.25 12.25C15.8023 12.25 16.25 11.8023 16.25 11.25C16.25 10.6977 15.8023 10.25 15.25 10.25V12.25ZM12.75 20.25C12.1977 20.25 11.75 20.6977 11.75 21.25C11.75 21.8023 12.1977 22.25 12.75 22.25V20.25ZM17.75 22.25C18.3023 22.25 18.75 21.8023 18.75 21.25C18.75 20.6977 18.3023 20.25 17.75 20.25V22.25ZM10.25 26.5C9.69772 26.5 9.25 26.9477 9.25 27.5C9.25 28.0523 9.69772 28.5 10.25 28.5V26.5ZM15.25 28.5C15.8023 28.5 16.25 28.0523 16.25 27.5C16.25 26.9477 15.8023 26.5 15.25 26.5V28.5ZM27.75 26.5C27.1977 26.5 26.75 26.9477 26.75 27.5C26.75 28.0523 27.1977 28.5 27.75 28.5V26.5ZM30.25 28.5C30.8023 28.5 31.25 28.0523 31.25 27.5C31.25 26.9477 30.8023 26.5 30.25 26.5V28.5ZM27.75 20.25C27.1977 20.25 26.75 20.6977 26.75 21.25C26.75 21.8023 27.1977 22.25 27.75 22.25V20.25ZM30.25 22.25C30.8023 22.25 31.25 21.8023 31.25 21.25C31.25 20.6977 30.8023 20.25 30.25 20.25V22.25ZM2.75 34.75H37.75V32.75H2.75V34.75ZM23.75 33.75V6.25H21.75V33.75H23.75ZM23.75 6.25C23.75 5.65326 23.5129 5.08097 23.091 4.65901L21.6768 6.07322C21.7237 6.12011 21.75 6.18369 21.75 6.25H23.75ZM23.091 4.65901C22.669 4.23705 22.0967 4 21.5 4V6C21.5663 6 21.6299 6.02634 21.6768 6.07322L23.091 4.65901ZM21.5 4H6.5V6H21.5V4ZM6.5 4C5.90326 4 5.33097 4.23705 4.90901 4.65901L6.32322 6.07322C6.37011 6.02634 6.4337 6 6.5 6V4ZM4.90901 4.65901C4.48705 5.08097 4.25 5.65326 4.25 6.25H6.25C6.25 6.1837 6.27634 6.12011 6.32322 6.07322L4.90901 4.65901ZM4.25 6.25V33.75H6.25V6.25H4.25ZM36.25 33.75V16.25H34.25V33.75H36.25ZM36.25 16.25C36.25 15.6533 36.013 15.081 35.591 14.659L34.1768 16.0732C34.2237 16.1201 34.25 16.1837 34.25 16.25H36.25ZM35.591 14.659C35.169 14.2371 34.5967 14 34 14V16C34.0663 16 34.1299 16.0263 34.1768 16.0732L35.591 14.659ZM34 14H22.75V16H34V14ZM10.25 12.25H15.25V10.25H10.25V12.25ZM12.75 22.25H17.75V20.25H12.75V22.25ZM10.25 28.5H15.25V26.5H10.25V28.5ZM27.75 28.5H30.25V26.5H27.75V28.5ZM27.75 22.25H30.25V20.25H27.75V22.25Z" fill="currentColor"/>
                                                                </svg>
                                                                زمان تحویل
                                                                <span class="custom-option-title"> دفتر</span>
                                                                <small> (9 صبح تا 5 بعد از ظهر)</small>
                                                            </span>
                                                            <input class="form-check-input" id="customRadioOffice" name="customRadioIcon" type="radio" value=""/>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <label class="form-label" for="modalAddressFirstName">نام کوچک</label>
                                            <input class="form-control" id="modalAddressFirstName" name="modalAddressFirstName" placeholder="امیر" type="text"/>
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <label class="form-label" for="modalAddressLastName">نام خانوادگی</label>
                                            <input class="form-control" id="modalAddressLastName" name="modalAddressLastName" placeholder="مقصودلو" type="text"/>
                                        </div>
                                        <div class="col-12">
                                            <label class="form-label" for="modalAddressCountry">کشور</label>
                                            <select class="select2 form-select" data-allow-clear="true" id="modalAddressCountry" name="modalAddressCountry">
                                                <option value="">انتخاب کنید</option>
                                                <option value="Australia">استرالیا</option>
                                                <option value="Bangladesh">بنگلادش</option>
                                                <option value="Belarus">بلاروس</option>
                                                <option value="Brazil">برزیل</option>
                                                <option value="Canada">کانادا</option>
                                                <option value="China">چین</option>
                                                <option value="France">فرانسه</option>
                                                <option value="Germany">آلمان</option>
                                                <option value="India">هندوستان</option>
                                                <option value="Indonesia">اندونزی</option>
                                                <option value="Israel">اسرائيل</option>
                                                <option value="Italy">ایتالیا</option>
                                                <option value="Japan">ژاپن</option>
                                                <option value="Korea">جمهوری کره</option>
                                                <option value="Mexico">مکزیک</option>
                                                <option value="Philippines">فیلیپین</option>
                                                <option value="Russia">فدراسیون روسیه</option>
                                                <option value="South Africa">آفریقای جنوبی</option>
                                                <option value="Thailand">تایلند</option>
                                                <option value="Turkey">ترکیه</option>
                                                <option value="Ukraine">اوکراین</option>
                                                <option value="United Arab Emirates">امارات متحده عربی</option>
                                                <option value="United Kingdom">انگلستان</option>
                                                <option value="United States">ایالات متحده</option>
                                            </select>
                                        </div>
                                        <div class="col-12">
                                            <label class="form-label" for="modalAddressAddress1">آدرس خط 1</label>
                                            <input class="form-control" id="modalAddressAddress1" name="modalAddressAddress1" placeholder="12، بیزینس پارک" type="text"/>
                                        </div>
                                        <div class="col-12">
                                            <label class="form-label" for="modalAddressAddress2">آدرس خط 2</label>
                                            <input class="form-control" id="modalAddressAddress2" name="modalAddressAddress2" placeholder="جاده مال" type="text"/>
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <label class="form-label" for="modalAddressLandmark">راهنما</label>
                                            <input class="form-control" id="modalAddressLandmark" name="modalAddressLandmark" placeholder="شماره کافه هارد راک" type="text"/>
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <label class="form-label" for="modalAddressCity">شهر</label>
                                            <input class="form-control" id="modalAddressCity" name="modalAddressCity" placeholder="لس آنجلس" type="text"/>
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <label class="form-label" for="modalAddressLandmark">حالت</label>
                                            <input class="form-control" id="modalAddressState" name="modalAddressState" placeholder="کالیفرنیا" type="text"/>
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <label class="form-label" for="modalAddressZipCode">کد پستی</label>
                                            <input class="form-control" id="modalAddressZipCode" name="modalAddressZipCode" placeholder="99950" type="text"/>
                                        </div>
                                        <div class="col-12">
                                            <label class="switch">
                                                <input class="switch-input" type="checkbox"/>
                                                <span class="switch-toggle-slider">
                                                    <span class="switch-on"></span>
                                                    <span class="switch-off"></span>
                                                </span>
                                                <span class="switch-label">به عنوان آدرس صورتحساب استفاده شود؟</span>
                                            </label>
                                        </div>
                                        <div class="col-12 text-center">
                                            <button class="btn btn-primary me-sm-3 me-1" type="submit">ارسال</button>
                                            <button aria-label="بستن" class="btn btn-label-secondary" data-bs-dismiss="modal" type="reset"> لغو</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--/ Add New Address Modal -->
                </div>
                <!-- / Content -->
                <!-- Footer -->
                <footer class="content-footer footer bg-footer-theme">
                    <div class="container-xxl">
                        <div class="footer-container d-flex align-items-center justify-content-between py-2 flex-md-row flex-column">
                            <div> ©
                                <script>
                                    document.write(new Date().getFullYear());

                                </script>
                                , ارائه شده توسط
                                <span class="text-danger byte-hover">بایت ‌مَستر</span>
                                در سایت
                                <a class="fw-medium" href="#support" target="_blank">راستچین</a>
                            </div>
                            <div class="d-none d-lg-inline-block">
                                <a class="footer-link me-4" href="#support" target="_blank">لایسنس</a>
                                <a class="footer-link me-4" href="#support" target="_blank">قالب‌های بیشتر</a>
                                <a class="footer-link me-4" href="https://demos.pixinvent.com/vuexy-html-admin-template/documentation/" target="_blank">مستندات</a>
                                <a class="footer-link d-none d-sm-inline-block" href="#support-theme" target="_blank">پشتیبانی</a>
                            </div>
                        </div>
                    </div>
                </footer>
                <!-- / Footer -->
                <div class="content-backdrop fade"></div>
            </div>
            <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
    </div>
    <!-- Overlay -->
    <div class="layout-overlay layout-menu-toggle"></div>
    <!-- Drag Target Area To SlideIn Menu On Small Screens -->
    <div class="drag-target"></div>
</div>
<!-- / Layout wrapper -->
<!-- Core JS -->
<!-- build:js assets/vendor/js/core.js -->
<script src="../../../assets/vendor/libs/popper/popper.js"></script>
<script src="../../../assets/vendor/js/bootstrap.js"></script>
<script src="../../../assets/vendor/libs/node-waves/node-waves.js"></script>
<script src="../../../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="../../../assets/vendor/libs/hammer/hammer.js"></script>
<script src="../../../assets/vendor/libs/i18n/i18n.js"></script>
<script src="../../../assets/vendor/libs/typeahead-js/typeahead.js"></script>
<script src="../../../assets/vendor/js/menu.js"></script>
<!-- endbuild -->
<!-- Vendors JS -->
<script src="../../../assets/vendor/libs/moment/moment.js"></script>
<script src="../../../assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js"></script>
<script src="../../../assets/vendor/libs/datatables-bs5/i18n/fa.js"></script>
<script src="../../../assets/vendor/libs/sweetalert2/sweetalert2.js"></script>
<script src="../../../assets/vendor/libs/cleavejs/cleave.js"></script>
<script src="../../../assets/vendor/libs/cleavejs/cleave-phone.js"></script>
<script src="../../../assets/vendor/libs/select2/select2.js"></script>
<script src="../../../assets/vendor/libs/select2/i18n/fa.js"></script>
<script src="../../../assets/vendor/libs/@form-validation/popular.js"></script>
<script src="../../../assets/vendor/libs/@form-validation/bootstrap5.js"></script>
<script src="../../../assets/vendor/libs/@form-validation/auto-focus.js"></script>
<!-- Main JS -->
<script src="../../../assets/js/main.js"></script>
<!-- Page JS -->
<script src="../../../assets/js/modal-edit-user.js"></script>
<script src="../../../assets/js/app-user-view.js"></script>
<script src="../../../assets/js/app-user-view-account.js"></script>
</html>
