<?php
session_start();
require 'auth21.php';
if (empty($_SESSION['user_code'])) {
    header("Location: login");
    exit;
}
$user = getUser($pdo);
if ($user['account_status'] == "NOTSIGNEDUP") {
    header("Location: registration");
    exit;
}
?>
<!DOCTYPE html>
<html class="light-style layout-navbar-fixed layout-menu-fixed layout-compact" data-assets-path="../../assets/" data-template="vertical-menu-template-no-customizer" data-theme="theme-default" dir="rtl" lang="fa">

<head>
    <meta charset="UTF-8"/>
    <meta content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" name="viewport"/>
    <title>یونیت‌های دندانپزشکی | Vuexy</title>
    <link href="../../assets/img/favicon/favicon.ico" rel="icon" type="image/x-icon"/>
    <link href="../../assets/vendor/fonts/fontawesome.css" rel="stylesheet"/>
    <link href="../../assets/vendor/fonts/tabler-icons.css" rel="stylesheet"/>
    <link href="../../assets/vendor/fonts/flag-icons.css" rel="stylesheet"/>
    <link href="../../assets/vendor/css/rtl/core.css" rel="stylesheet"/>
    <link href="../../assets/vendor/css/rtl/theme-default.css" rel="stylesheet"/>
    <link href="../../assets/css/demo.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/node-waves/node-waves.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/typeahead-js/typeahead.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/select2/select2.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/@form-validation/form-validation.css" rel="stylesheet"/>
    <link rel="stylesheet" href="../../assets/vendor/libs/sweetalert2/sweetalert2.css"/>
    <script src="../../assets/vendor/js/helpers.js"></script>
    <script src="../../assets/js/jquery-3.6.0.min.js"></script>
    <script src="../../assets/vendor/libs/sweetalert2/sweetalert2.js"></script>
    <script src="../../assets/js/config.js"></script>
    <link href="../../assets/css/rtl.css" rel="stylesheet"/>
</head>

<body>
<div class="layout-wrapper layout-content-navbar">
    <div class="layout-container">
        <?php require_once 'sidebar.php';?>
        <div class="layout-page">
            <?php require_once 'navbar.php';?>
            <div class="content-wrapper">
                <div class="container-xxl flex-grow-1 container-p-y">
                    <div class="card">
                        <div class="card-header border-bottom">
                            <h5 class="card-title mb-3">سفارشات لابراتوار</h5>
                            <a href="<?=ROOT.'add-order'?>" class="btn btn-secondary add-new btn-primary waves-effect waves-light">
                                <i class="ti ti-plus me-0 me-sm-1 ti-xs"></i>
                                <span class="d-none d-sm-inline-block">سفارش جدید</span>
                            </a>
                        </div>
                        <div class="card-datatable table-responsive">
                            <table class="datatables-orders table">
                                <thead class="border-top">
                                <tr>
                                    <th>شماره سفارش</th>
                                    <th>نام دندانپزشک</th>
                                    <th>نام لابراتوار</th>
                                    <th>نام بیمار</th>
                                    <th>تاریخ سفارش</th>
                                    <th>وضعیت</th>
                                    <th>عملیات</th>
                                </tr>
                                </thead>
                            </table>
                        </div>
                        <script>
                            $(document).ready(function () {
                                $('.datatables-orders').DataTable({
                                    processing: true,
                                    ajax: {
                                        url: '<?=ROOT?>functions/orders_funcs.php',
                                        type: 'POST',
                                        data: { action: 'load_orders' },
                                        dataSrc: function(json) {
                                            console.log("JSON response from server:", json); // <-- show the response
                                            return json.data; // DataTables expects an array here
                                        },
                                        error: function(xhr, status, error) {
                                            console.error("AJAX error:", status, error);
                                            console.log("Response text:", xhr.responseText);
                                        }
                                    },
                                    columns: [
                                        { data: 'number' },
                                        { data: 'dentist_name' },
                                        { data: 'lab_name' },
                                        { data: 'patient_name' },
                                        { data: 'date' },
                                        { data: 'status' },
                                        { data: 'actions', orderable: false, searchable: false }
                                    ]
                                });
                            });
                        </script>
                        <!-- Offcanvas -->
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- / Layout wrapper -->
<!-- Core JS -->
<!-- build:js assets/vendor/js/core.js -->
<script src="../../assets/vendor/libs/jquery/jquery.js"></script>
<script src="../../assets/vendor/libs/popper/popper.js"></script>
<script src="../../assets/vendor/js/bootstrap.js"></script>
<script src="../../assets/vendor/libs/node-waves/node-waves.js"></script>
<script src="../../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="../../assets/vendor/libs/hammer/hammer.js"></script>
<script src="../../assets/vendor/libs/i18n/i18n.js"></script>
<script src="../../assets/vendor/libs/typeahead-js/typeahead.js"></script>
<script src="../../assets/vendor/js/menu.js"></script>
<!-- endbuild -->
<!-- Vendors JS -->
<script src="../../assets/vendor/libs/moment/moment.js"></script>
<script src="../../assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js"></script>
<script src="../../assets/vendor/libs/datatables-bs5/i18n/fa.js"></script>
<script src="../../assets/vendor/libs/select2/select2.js"></script>
<script src="../../assets/vendor/libs/select2/i18n/fa.js"></script>
<script src="../../assets/vendor/libs/@form-validation/popular.js"></script>
<script src="../../assets/vendor/libs/@form-validation/bootstrap5.js"></script>
<script src="../../assets/vendor/libs/@form-validation/auto-focus.js"></script>
<script src="../../assets/vendor/libs/cleavejs/cleave.js"></script>
<script src="../../assets/vendor/libs/cleavejs/cleave-phone.js"></script>
<!-- Main JS -->
<script src="../../assets/js/main.js"></script>
<!-- Page JS -->
</body>
</html>
