<?php
session_start();
require 'auth21.php';
if (empty($_SESSION['user_code'])) {
    header("Location: login");
    exit;
}
$user = getUser($pdo);
if($user['account_status'] == "NOTSIGNEDUP"){
    header("Location: registration");
    exit;
}
?>
<!DOCTYPE html>
<html class="light-style layout-navbar-fixed layout-menu-fixed layout-compact" data-assets-path="../../assets/" data-template="vertical-menu-template-no-customizer" data-theme="theme-default" dir="rtl" lang="fa">

<head>
    <meta charset="UTF-8"/>
    <meta content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" name="viewport"/>
    <title>مدیریت بیماران</title>
    <meta content="" name="description"/>
    <!-- Favicon -->
    <link href="../../assets/img/favicon/favicon.ico" rel="icon" type="image/x-icon"/>
    <!-- Icons -->
    <link href="../../assets/vendor/fonts/fontawesome.css" rel="stylesheet"/>
    <link href="../../assets/vendor/fonts/tabler-icons.css" rel="stylesheet"/>
    <link href="../../assets/vendor/fonts/flag-icons.css" rel="stylesheet"/>
    <!-- Core CSS -->
    <link href="../../assets/vendor/css/rtl/core.css" rel="stylesheet"/>
    <link href="../../assets/vendor/css/rtl/theme-default.css" rel="stylesheet"/>
    <link href="../../assets/css/demo.css" rel="stylesheet"/>
    <!-- Vendors CSS -->
    <link href="../../assets/vendor/libs/node-waves/node-waves.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/typeahead-js/typeahead.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/select2/select2.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/@form-validation/form-validation.css" rel="stylesheet"/>
    <link rel="stylesheet" href="../../assets/vendor/libs/sweetalert2/sweetalert2.css" />

    <!-- Page CSS -->
    <!-- Helpers -->
    <script src="../../assets/vendor/js/helpers.js"></script>
    <script src="../../assets/js/jquery-3.6.0.min.js"></script>
    <script src="../../assets/vendor/libs/sweetalert2/sweetalert2.js"></script>
    <script src="../../assets/js/config.js"></script>
    <!-- Better experience of RTL -->
    <link href="../../assets/css/rtl.css" rel="stylesheet"/>
</head>

<body>
<!-- Layout wrapper -->
<div class="layout-wrapper layout-content-navbar">
    <div class="layout-container">
        <!-- Menu -->
        <?php require_once 'sidebar.php';?>
        <!-- / Menu -->
        <!-- Layout container -->
        <div class="layout-page">
            <!-- Navbar -->
            <?php require_once 'navbar.php';?>
            <!-- / Navbar -->
            <!-- Content wrapper -->
            <div class="content-wrapper">
                <!-- Content -->
                <div class="container-xxl flex-grow-1 container-p-y">
                    <!-- Patients List Table -->
                    <div class="card">
                        <div class="card-header border-bottom">
                            <h5 class="card-title mb-3">بیماران</h5>
                            <button class="btn btn-secondary add-new btn-primary waves-effect waves-light" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasAddPatient">
                                <i class="ti ti-plus me-0 me-sm-1 ti-xs"></i><span class="d-none d-sm-inline-block">افزودن بیمار</span>
                            </button>
                        </div>
                        <div class="card-datatable table-responsive">
                            <table class="datatables-patients table">
                                <thead class="border-top">
                                <tr>
                                    <th>شماره پرونده</th>
                                    <th>نام</th>
                                    <th>نام خانوادگی</th>
                                    <th>کد ملی</th>
                                    <th>شماره موبایل</th>
                                    <th>وضعیت</th>
                                    <th>عملیات</th>
                                </tr>
                                </thead>
                            </table>
                        </div>
                        <script>
                            $(document).ready(function () {
                                $('.datatables-patients').DataTable({
                                    processing: true,
                                    ajax: {
                                        url: 'functions/patients_funcs.php',
                                        type: 'POST',
                                        data: { action: 'load_patients' },
                                        dataSrc: 'data'
                                    },
                                    columns: [
                                        { data: 'case_number' },
                                        { data: 'firstname' },
                                        { data: 'lastname' },
                                        { data: 'nationalid' },
                                        { data: 'phone' },
                                        { data: 'status', orderable: false, searchable: false },
                                        { data: 'actions', orderable: false, searchable: false },
                                        { data: 'barcode', visible: false }
                                    ]
                                });
                            });

                            // Delete Patient
                            $(document).on('click', '.delete-patient', function () {
                                const patientId = $(this).data('code');
                                Swal.fire({
                                    title: 'مطمئنی؟',
                                    text: 'این بیمار برای همیشه حذف خواهد شد!',
                                    icon: 'warning',
                                    showCancelButton: true,
                                    confirmButtonText: 'بله, حذف شود!',
                                    cancelButtonText: 'بازگشت',
                                    customClass: {
                                        confirmButton: 'btn btn-danger me-3 waves-effect waves-light',
                                        cancelButton: 'btn btn-label-secondary waves-effect waves-light'
                                    },
                                    buttonsStyling: false
                                }).then(function (result) {
                                    if (result.isConfirmed) {
                                        fetch('functions/patients_funcs.php', {
                                            method: 'POST',
                                            body: new URLSearchParams({ action: 'delete_patient', code: patientId })
                                        })
                                            .then(r => r.json())
                                            .then(data => {
                                                if (data.success) {
                                                    $('.datatables-patients').DataTable().ajax.reload();
                                                    Swal.fire({
                                                        icon: 'success',
                                                        title: 'حذف شد!',
                                                        text: data.message || 'بیمار با موفقیت حذف شد.',
                                                        confirmButtonText: 'باشه',
                                                        customClass: { confirmButton: 'btn btn-success waves-effect waves-light' }
                                                    });
                                                } else {
                                                    Swal.fire({
                                                        title: 'لغو شده',
                                                        text: data.error || 'خطایی در حذف رخ داد.',
                                                        icon: 'error',
                                                        confirmButtonText: 'باشه',
                                                        customClass: { confirmButton: 'btn btn-success waves-effect waves-light' }
                                                    });
                                                }
                                            })
                                            .catch(() => {
                                                Swal.fire({
                                                    title: 'خطا',
                                                    text: 'مشکل ارتباط با سرور',
                                                    icon: 'error',
                                                    confirmButtonText: 'باشه',
                                                    customClass: { confirmButton: 'btn btn-success waves-effect waves-light' }
                                                });
                                            });
                                    }
                                });
                            });
                        </script>
                        <!-- Offcanvas to add new patient -->
                        <div class="offcanvas offcanvas-end" id="offcanvasAddPatient" tabindex="-1">
                            <div class="offcanvas-header">
                                <h5 class="offcanvas-title">افزودن بیمار</h5>
                                <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="بستن"></button>
                            </div>
                            <div class="offcanvas-body">
                                <form id="addNewPatientForm">
                                    <div class="mb-3">
                                        <label class="form-label" for="add-patient-firstname">نام</label>
                                        <input type="text" class="form-control" id="add-patient-firstname" name="add-patient-firstname" placeholder="عباس" />
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label" for="add-patient-lastname">نام خانوادگی</label>
                                        <input type="text" class="form-control" id="add-patient-lastname" name="add-patient-lastname" placeholder="محمدی" />
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label" for="add-patient-nationalid">کد ملی</label>
                                        <input type="text" class="form-control" id="add-patient-nationalid" name="add-patient-nationalid" placeholder="0012345678" />
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label" for="add-patient-phone">شماره موبایل</label>
                                        <input type="text" class="form-control" id="add-patient-phone" name="add-patient-phone" placeholder="09123456789" />
                                    </div>
                                    <button type="button" id="addPatientBtn" class="btn btn-primary me-sm-3 me-1 data-submit">افزودن</button>
                                    <button type="reset" class="btn btn-label-secondary" data-bs-dismiss="offcanvas">لغو</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <script>
                    document.getElementById('addPatientBtn').addEventListener('click', function () {
                        const form = document.getElementById('addNewPatientForm');
                        const formData = new FormData(form);
                        formData.append('action', 'add_patient');

                        fetch('functions/patients_funcs.php', {
                            method: 'POST',
                            body: formData
                        })
                            .then(r => r.json())
                            .then(data => {
                                if (data.success) {
                                    Swal.fire({
                                        icon: 'success',
                                        title: 'موفق!',
                                        text: data.message || 'بیمار با موفقیت اضافه شد.',
                                        confirmButtonText: 'باشه',
                                        customClass: { confirmButton: 'btn btn-success waves-effect waves-light' }
                                    });
                                    $('.datatables-patients').DataTable().ajax.reload();
                                    form.reset();
                                } else {
                                    Swal.fire({
                                        icon: 'error',
                                        title: 'خطا',
                                        text: data.error || 'خطا در ذخیره بیمار',
                                        confirmButtonText: 'باشه',
                                        customClass: { confirmButton: 'btn btn-danger waves-effect waves-light' }
                                    });
                                }
                            })
                            .catch(() => {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'خطای ارتباط',
                                    text: 'خطای ارتباط با سرور',
                                    confirmButtonText: 'باشه',
                                    customClass: { confirmButton: 'btn btn-danger waves-effect waves-light' }
                                });
                            });
                    });

                    // Edit Patient
                    $(document).on('click', '.edit-patient', function () {
                        const patientId = $(this).data('code');

                        fetch('functions/patients_funcs.php', {
                            method: 'POST',
                            body: new URLSearchParams({ action: 'get_patient', code: patientId })
                        })
                            .then(r => r.json())
                            .then(data => {
                                if (!data.success) {
                                    Swal.fire({ icon: 'error', title: 'خطا', text: data.error || 'بیمار یافت نشد' });
                                    return;
                                }

                                const p = data.patient;
                                Swal.fire({
                                    title: 'ویرایش بیمار',
                                    html: `
                                        <input id="swal-edit-firstname" class="swal2-input" placeholder="نام" value="${p.firstname || ''}">
                                        <input id="swal-edit-lastname" class="swal2-input" placeholder="نام خانوادگی" value="${p.lastname || ''}">
                                        <input id="swal-edit-nationalid" class="swal2-input" placeholder="کد ملی" value="${p.nationalid || ''}">
                                        <input id="swal-edit-phone" class="swal2-input" placeholder="شماره موبایل" value="${p.phone || ''}">
                                    `,
                                    showCancelButton: true,
                                    confirmButtonText: 'ذخیره تغییرات',
                                    cancelButtonText: 'لغو',
                                    customClass: {
                                        confirmButton: 'btn btn-primary me-3',
                                        cancelButton: 'btn btn-label-secondary'
                                    },
                                    preConfirm: () => {
                                        return {
                                            code: patientId,
                                            firstname: document.getElementById('swal-edit-firstname').value.trim(),
                                            lastname: document.getElementById('swal-edit-lastname').value.trim(),
                                            nationalid: document.getElementById('swal-edit-nationalid').value.trim(),
                                            phone: document.getElementById('swal-edit-phone').value.trim()
                                        };
                                    }
                                }).then(result => {
                                    if (result.isConfirmed) {
                                        const fd = new FormData();
                                        fd.append('action', 'update_patient');
                                        for (const key in result.value) {
                                            fd.append(key, result.value[key]);
                                        }

                                        fetch('functions/patients_funcs.php', { method: 'POST', body: fd })
                                            .then(r => r.json())
                                            .then(update => {
                                                if (update.success) {
                                                    $('.datatables-patients').DataTable().ajax.reload();
                                                    Swal.fire({
                                                        icon: 'success',
                                                        title: 'موفق!',
                                                        text: update.message || 'بیمار با موفقیت بروزرسانی شد.',
                                                        confirmButtonText: 'باشه',
                                                        customClass: { confirmButton: 'btn btn-success waves-effect waves-light' }
                                                    });
                                                } else {
                                                    Swal.fire({
                                                        icon: 'error',
                                                        title: 'خطا!',
                                                        text: update.error || 'بروزرسانی انجام نشد.',
                                                        confirmButtonText: 'باشه',
                                                        customClass: { confirmButton: 'btn btn-primary waves-effect waves-light' }
                                                    });
                                                }
                                            });
                                    }
                                });
                            });
                    });
                </script>
                <!-- / Content -->

                <!-- Footer -->
                <footer class="content-footer footer bg-footer-theme">
                    <div class="container-xxl">
                        <div class="footer-container d-flex align-items-center justify-content-between py-2 flex-md-row flex-column">
                            <div> ©
                                <script>document.write(new Date().getFullYear());</script>
                                , ارائه شده توسط
                                <span class="text-danger byte-hover">بایت ‌مَستر</span>
                                در سایت
                                <a class="fw-medium" href="#support" target="_blank">راستچین</a>
                            </div>
                            <div class="d-none d-lg-inline-block">
                                <a class="footer-link me-4" href="#support" target="_blank">لایسنس</a>
                                <a class="footer-link me-4" href="#support" target="_blank">قالب‌های بیشتر</a>
                                <a class="footer-link me-4" href="https://demos.pixinvent.com/vuexy-html-admin-template/documentation/" target="_blank">مستندات</a>
                                <a class="footer-link d-none d-sm-inline-block" href="#support-theme" target="_blank">پشتیبانی</a>
                            </div>
                        </div>
                    </div>
                </footer>
                <!-- / Footer -->
                <div class="content-backdrop fade"></div>
            </div>
        </div>
    </div>
    <div class="layout-overlay layout-menu-toggle"></div>
    <div class="drag-target"></div>
</div>

<!-- Core JS -->
<script src="../../assets/vendor/libs/jquery/jquery.js"></script>
<script src="../../assets/vendor/libs/popper/popper.js"></script>
<script src="../../assets/vendor/js/bootstrap.js"></script>
<script src="../../assets/vendor/libs/node-waves/node-waves.js"></script>
<script src="../../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="../../assets/vendor/libs/hammer/hammer.js"></script>
<script src="../../assets/vendor/libs/i18n/i18n.js"></script>
<script src="../../assets/vendor/libs/typeahead-js/typeahead.js"></script>
<script src="../../assets/vendor/js/menu.js"></script>
<!-- Vendors JS -->
<script src="../../assets/vendor/libs/moment/moment.js"></script>
<script src="../../assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js"></script>
<script src="../../assets/vendor/libs/datatables-bs5/i18n/fa.js"></script>
<script src="../../assets/vendor/libs/select2/select2.js"></script>
<script src="../../assets/vendor/libs/@form-validation/popular.js"></script>
<script src="../../assets/vendor/libs/@form-validation/bootstrap5.js"></script>
<script src="../../assets/vendor/libs/@form-validation/auto-focus.js"></script>
<script src="../../assets/vendor/libs/cleavejs/cleave.js"></script>
<script src="../../assets/vendor/libs/cleavejs/cleave-phone.js"></script>
<!-- Main JS -->
<script src="../../assets/js/main.js"></script>
</body>
</html>
