<?php
session_start();
require 'auth21.php';
if (empty($_SESSION['user_code'])) {
    header("Location: login");
    exit;
}
$user = getUser($pdo);
if($user['account_status'] == "NOTSIGNEDUP"){
    header("Location: registration");
    exit;
}
?>
<!DOCTYPE html>
<html class="light-style layout-navbar-fixed layout-menu-fixed layout-compact" data-assets-path="../../assets/" data-template="vertical-menu-template-no-customizer" data-theme="theme-default" dir="rtl" lang="fa">

<head>
    <meta charset="UTF-8"/>
    <meta content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" name="viewport"/>
    <title>مدیریت خدمات و دسته‌بندی‌ها | Vuexy</title>
    <meta content="" name="description"/>
    <link href="../../assets/img/favicon/favicon.ico" rel="icon" type="image/x-icon"/>
    <link href="../../assets/vendor/fonts/fontawesome.css" rel="stylesheet"/>
    <link href="../../assets/vendor/fonts/tabler-icons.css" rel="stylesheet"/>
    <link href="../../assets/vendor/fonts/flag-icons.css" rel="stylesheet"/>
    <link href="../../assets/vendor/css/rtl/core.css" rel="stylesheet"/>
    <link href="../../assets/vendor/css/rtl/theme-default.css" rel="stylesheet"/>
    <link href="../../assets/css/demo.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/node-waves/node-waves.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/typeahead-js/typeahead.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/select2/select2.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/@form-validation/form-validation.css" rel="stylesheet"/>
    <link rel="stylesheet" href="../../assets/vendor/libs/sweetalert2/sweetalert2.css" />
    <script src="../../assets/vendor/js/helpers.js"></script>
    <script src="../../assets/js/jquery-3.6.0.min.js"></script>
    <script src="../../assets/vendor/libs/sweetalert2/sweetalert2.js"></script>
    <script src="../../assets/js/config.js"></script>
    <link href="../../assets/css/rtl.css" rel="stylesheet"/>
</head>

<body>
<div class="layout-wrapper layout-content-navbar">
    <div class="layout-container">
        <?php require_once 'sidebar.php';?>
        <div class="layout-page">
            <?php require_once 'navbar.php';?>
            <div class="content-wrapper">
                <div class="container-xxl flex-grow-1 container-p-y">

                    <!-- Tabs -->
                    <ul class="nav nav-tabs" id="servicesTab" role="tablist">
                        <li class="nav-item">
                            <button class="nav-link active" id="services-tab" data-bs-toggle="tab" data-bs-target="#services-pane" type="button" role="tab">خدمات</button>
                        </li>
                        <li class="nav-item">
                            <button class="nav-link" id="categories-tab" data-bs-toggle="tab" data-bs-target="#categories-pane" type="button" role="tab">دسته‌بندی‌ها</button>
                        </li>
                    </ul>

                    <div class="tab-content" id="servicesTabContent">

                        <!-- خدمات Tab -->
                        <div class="tab-pane fade show active" id="services-pane" role="tabpanel">
                            <div class="card mt-3">
                                <div class="card-header border-bottom">
                                    <h5 class="card-title mb-3">خدمات</h5>
                                    <button class="btn btn-secondary add-new btn-primary waves-effect waves-light" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasAddService">
                                        <span><i class="ti ti-plus me-0 me-sm-1 ti-xs"></i><span class="d-none d-sm-inline-block">افزودن خدمت</span></span>
                                    </button>
                                </div>
                                <div class="card-datatable table-responsive">
                                    <table class="datatables-services table">
                                        <thead class="border-top">
                                        <tr>
                                            <th>عنوان خدمت</th>
                                            <th>دسته‌بندی</th>
                                            <th>قیمت</th>
                                            <th>حسابداری</th>
                                            <th>وضعیت</th>
                                            <th>عملیات</th>
                                        </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <!-- دسته‌بندی‌ها Tab -->
                        <div class="tab-pane fade" id="categories-pane" role="tabpanel">
                            <div class="card mt-3">
                                <div class="card-header border-bottom">
                                    <h5 class="card-title mb-3">دسته‌بندی‌ها</h5>
                                    <button class="btn btn-secondary add-new btn-primary waves-effect waves-light" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasAddCategory">
                                        <span><i class="ti ti-plus me-0 me-sm-1 ti-xs"></i><span class="d-none d-sm-inline-block">افزودن دسته‌بندی</span></span>
                                    </button>
                                </div>
                                <div class="card-datatable table-responsive">
                                    <table class="datatables-categories table">
                                        <thead class="border-top">
                                        <tr>
                                            <th>عنوان دسته‌بندی</th>
                                            <th>وضعیت</th>
                                            <th>عملیات</th>
                                        </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                        </div>

                    </div>

                    <!-- Offcanvas: Add Service -->
                    <div class="offcanvas offcanvas-end" id="offcanvasAddService" tabindex="-1">
                        <div class="offcanvas-header">
                            <h5 class="offcanvas-title">افزودن خدمت</h5>
                            <button class="btn-close text-reset" data-bs-dismiss="offcanvas" type="button"></button>
                        </div>
                        <div class="offcanvas-body pt-0 h-100">
                            <form id="addNewServiceForm">
                                <div class="mb-3">
                                    <label class="form-label" for="add-service-title">عنوان خدمت</label>
                                    <input class="form-control" id="add-service-title" name="add-service-title" type="text"/>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label" for="add-service-category">دسته‌بندی</label>
                                    <select class="form-select" id="add-service-category" name="add-service-category">
                                        <?php
                                        $cats = $pdo->prepare("SELECT service_category_code, category_title FROM service_categories WHERE office_code = ? AND status='ACTIVE'");
                                        $cats->execute([$_SESSION['user_code']]);
                                        foreach($cats->fetchAll(PDO::FETCH_ASSOC) as $cat){
                                            echo '<option value="'.htmlspecialchars($cat['service_category_code']).'">'.htmlspecialchars($cat['category_title']).'</option>';
                                        }
                                        ?>
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label" for="add-service-tariff">تعرفه</label>
                                    <select class="form-select" id="add-service-tariff" name="add-service-tariff" onchange="change_tariff(this);">
                                        <option value="NA">بدون تعرفه</option>
                                        <option value="add-tariff">افزودن تعرفه</option>
                                    </select>
                                </div>
                                <div id="tariffPanel" style="display: none;">
                                    <div class="mb-3">
                                        <label class="form-label" for="add-tariff-price">هزینه خدمت* (تومان)</label>
                                        <input class="form-control" id="add-tariff-price" name="add-tariff-price" type="text" inputmode="numeric" onkeyup="thousand_sepr(this)"/>
                                    </div>
                                    <div class="form-check mt-2">
                                        <input class="form-check-input" id="add-tariff-type" name="add-tariff-type" type="checkbox">
                                        <label class="form-check-label mb-2" for="add-tariff-type">در حسابداری لحاظ شود؟</label>
                                    </div>
                                </div>
                                <button id="addServiceBtn" class="btn btn-primary me-1" type="button">افزودن</button>
                                <button class="btn btn-label-secondary" data-bs-dismiss="offcanvas" type="reset">لغو</button>
                            </form>
                        </div>
                    </div>

                    <!-- Offcanvas: Add Category -->
                    <div class="offcanvas offcanvas-end" id="offcanvasAddCategory" tabindex="-1">
                        <div class="offcanvas-header">
                            <h5 class="offcanvas-title">افزودن دسته‌بندی</h5>
                            <button class="btn-close text-reset" data-bs-dismiss="offcanvas" type="button"></button>
                        </div>
                        <div class="offcanvas-body pt-0 h-100">
                            <form id="addNewCategoryForm">
                                <div class="mb-3">
                                    <label class="form-label" for="add-category-title">عنوان دسته‌بندی</label>
                                    <input class="form-control" id="add-category-title" name="add-category-title" type="text"/>
                                </div>
                                <button id="addCategoryBtn" class="btn btn-primary me-1" type="button">افزودن</button>
                                <button class="btn btn-label-secondary" data-bs-dismiss="offcanvas" type="reset">لغو</button>
                            </form>
                        </div>
                    </div>

                </div>

                <footer class="content-footer footer bg-footer-theme">
                    <div class="container-xxl d-flex justify-content-between py-2 flex-md-row flex-column">
                        <div>© <script>document.write(new Date().getFullYear());</script>, ساخته شده با ❤️</div>
                    </div>
                </footer>
                <div class="content-backdrop fade"></div>
            </div>
        </div>
    </div>
</div>

<div class="layout-overlay layout-menu-toggle"></div>
<div class="drag-target"></div>
<script src="../../assets/vendor/libs/popper/popper.js"></script>
<script src="../../assets/vendor/js/bootstrap.js"></script>
<script src="../../assets/vendor/libs/node-waves/node-waves.js"></script>
<script src="../../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="../../assets/vendor/libs/hammer/hammer.js"></script>
<script src="../../assets/vendor/libs/i18n/i18n.js"></script>
<script src="../../assets/vendor/libs/typeahead-js/typeahead.js"></script>
<script src="../../assets/vendor/js/menu.js"></script>
<script src="../../assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js"></script>
<script src="../../assets/vendor/libs/datatables-bs5/i18n/fa.js"></script>
<script src="../../assets/vendor/libs/select2/select2.js"></script>
<script src="../../assets/vendor/libs/@form-validation/popular.js"></script>
<script src="../../assets/vendor/libs/@form-validation/bootstrap5.js"></script>
<script src="../../assets/vendor/libs/@form-validation/auto-focus.js"></script>
<script src="../../assets/js/main.js"></script>
<script>
    function change_tariff(select){
        if(select.id === "swal-edit-tariff"){
            $("#tariffPanel2").slideToggle("slow"); // fast, slow, or milliseconds
        }
        else {
            $("#tariffPanel").slideToggle("slow"); // fast, slow, or milliseconds
        }
    }
</script>
<!-- JS to init both tables -->
<script>
    $(function(){
        // Services table
        $('.datatables-services').DataTable({
            ajax:{ url:'functions/services_funcs.php', type:'POST', data:{action:'load_services'}, dataSrc: function(json) {
                    console.log("JSON response from server:", json); // <-- show the response
                    return json.data; // DataTables expects an array here
                },
                error: function(xhr, status, error) {
                    console.error("AJAX error:", status, error);
                    console.log("Response text:", xhr.responseText);
                }
            },
            columns:[
                {data:'service_title'},
                {data:'category_title'},
                {data:'price'},
                {data:'type'},
                {data:'status'},
                {data:'actions'}
            ]
        });

        // Categories table
        $('.datatables-categories').DataTable({
            ajax:{ url:'functions/services_funcs.php', type:'POST', data:{action:'load_service_categories'}, dataSrc:'data' },
            columns:[
                {data:'category_title'},
                {data:'status'},
                {data:'actions'}
            ]
        });

        // Add service
        $('#addServiceBtn').click(function(){
            let fd=new FormData($('#addNewServiceForm')[0]);
            fd.append('action','add_service');
            fetch('functions/services_funcs.php',{method:'POST',body:fd}).then(r=>r.json()).then(res=>{
                if(res.success){
                    $('.datatables-services').DataTable().ajax.reload();
                    $('#addNewServiceForm')[0].reset();
                    Swal.fire({
                        title: 'موفق',
                        text: res.message,
                        icon: 'success',
                        confirmButtonText: 'اوکی',
                        customClass: {
                            confirmButton: 'btn btn-danger me-3 waves-effect waves-light',
                        },
                        buttonsStyling: false
                    });
                } else {
                    Swal.fire({
                        title: 'خطا',
                        text: res.error,
                        icon: 'error',
                        confirmButtonText: 'اوکی',
                        customClass: {
                            confirmButton: 'btn btn-danger me-3 waves-effect waves-light',
                        },
                        buttonsStyling: false
                    });
                }
            });
        });

        // Add category
        $('#addCategoryBtn').click(function(){
            let fd=new FormData($('#addNewCategoryForm')[0]);
            fd.append('action','add_service_category');
            fetch('functions/services_funcs.php',{method:'POST',body:fd}).then(r=>r.json()).then(res=>{
                if(res.success){
                    $('.datatables-categories').DataTable().ajax.reload();
                    refreshServiceCategorySelect();
                    $('#addNewCategoryForm')[0].reset();
                    Swal.fire({
                        title: 'موفق',
                        text: res.message,
                        icon: 'success',
                        confirmButtonText: 'اوکی',
                        customClass: {
                            confirmButton: 'btn btn-danger me-3 waves-effect waves-light',
                        },
                        buttonsStyling: false
                    });
                } else {
                    Swal.fire({
                        title: 'خطا',
                        text: res.error,
                        icon: 'error',
                        confirmButtonText: 'اوکی',
                        customClass: {
                            confirmButton: 'btn btn-danger me-3 waves-effect waves-light',
                        },
                        buttonsStyling: false
                    });
                }
            });
        });

        // ===== SERVICES =====
        $(document).on('click', '.edit-service', function() {
            const serviceCode = $(this).data('code');
            const fd = new FormData();
            fd.append('action', 'get_service');
            fd.append('code', serviceCode);

            fetch('functions/services_funcs.php', {
                method: 'POST',
                body: fd
            })
                .then(res => res.json())
                .then(data => {
                    if (!data.success) {
                        Swal.fire({
                            title: 'خطا',
                            text: data.error,
                            icon: 'error',
                            confirmButtonText: 'اوکی',
                            customClass: {
                                confirmButton: 'btn btn-danger me-3 waves-effect waves-light',
                            },
                            buttonsStyling: false
                        });
                        return;
                    }

                    const s = data.service;
                    const t = data.tariff;
                    // load fresh categories dynamically
                    fetch('functions/services_funcs.php', {
                        method: 'POST',
                        body: new URLSearchParams({ action: 'fetch_categories_list' })
                    })
                        .then(r => r.json())
                        .then(catData => {
                            if (!catData.success) return;
                            let categoryOptions = '';
                            catData.categories.forEach(c => {
                                categoryOptions += `<option value="${c.code}" ${c.code===s.service_category_code?'selected':''}>${c.title}</option>`;
                            });

                            Swal.fire({
                                title: 'ویرایش خدمت',
                                html: `
                                <div class="mb-3">
                                    <label class="form-label" for="swal-edit-title">عنوان خدمت</label>
                                    <input id="swal-edit-title" class="form-select" placeholder="عنوان خدمت" value="${s.service_title || ''}">
                                </div>
                                <div class="mb-3">
                                    <label class="form-label" for="add-category-title">دسته بندی</label>
                                    <select id="swal-edit-category" class="form-select swal2-input mt-2">${categoryOptions}</select>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label" for="add-service-tariff">تعرفه</label>
                                    <select class="form-select" id="swal-edit-tariff" name="swal-edit-tariff" onchange="change_tariff(this);">
                                        <option value="NA">بدون تعرفه</option>
                                        <option value="add-tariff">افزودن تعرفه</option>
                                    </select>
                                </div>
                                <div id="tariffPanel2" style="display: none;">
                                    <div class="mb-3">
                                        <label class="form-label" for="swal-edit-tariff-price">هزینه خدمت* (تومان)</label>
                                        <input class="form-control" id="swal-edit-tariff-price" name="swal-edit-tariff-price" type="text" inputmode="numeric" onkeyup="thousand_sepr(this)"/>
                                    </div>
                                    <div class="form-check mt-2">
                                        <input class="form-check-input" id="swal-edit-tariff-type" name="swal-edit-tariff-type" type="checkbox" onchange="if(document.getElementById('swal-edit-tariff-type').checked === false){tariff_type = 'off'}else {tariff_type = 'on'};console.log(tariff_type)">
                                        <label class="form-check-label mb-2" for="swal-edit-tariff-type">در حسابداری لحاظ شود؟</label>
                                    </div>
                                </div>
                `,
                                showCancelButton: true,
                                confirmButtonText: 'ذخیره تغییرات',
                                cancelButtonText: 'لغو',
                                customClass: {
                                    confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                                    cancelButton:  'btn btn-label-secondary waves-effect waves-light'
                                },
                                buttonsStyling: false,
                                preConfirm: () => {
                                    return {
                                        code: serviceCode,
                                        service_title: document.getElementById('swal-edit-title').value.trim(),
                                        service_add_tariff: document.getElementById('swal-edit-tariff').value.trim(),
                                        service_tariff_price: document.getElementById('swal-edit-tariff-price').value.trim(),
                                        service_tariff_type: tariff_type,
                                        service_category_code: document.getElementById('swal-edit-category').value
                                    };
                                },
                                didOpen: () => {
                                    console.log(t);
                                    if(t){
                                        let tariff_type = 'off';
                                        document.getElementById('swal-edit-tariff').value = "add-tariff";
                                        change_tariff(document.getElementById('swal-edit-tariff'));
                                        document.getElementById('swal-edit-tariff-price').value = t.price;
                                        thousand_sepr(document.getElementById('swal-edit-tariff-price'));
                                        if(t.type === "COUNTABLE"){

                                            document.getElementById('swal-edit-tariff-type').checked = true;
                                            tariff_type = 'on';
                                        }
                                        else {
                                            document.getElementById('swal-edit-tariff-type').checked = false;
                                            tariff_type = 'off';
                                        }
                                    }
                                    else {
                                        document.getElementById('swal-edit-tariff').value = "NA";
                                        change_tariff(document.getElementById('swal-edit-tariff'));
                                    }
                                }
                            }).then(result => {
                                if (result.isConfirmed) {
                                    const fd2 = new FormData();
                                    fd2.append('action', 'update_service');
                                    for (const key in result.value) {
                                        fd2.append(key, result.value[key]);
                                    }
                                    fetch('functions/services_funcs.php', {
                                        method: 'POST',
                                        body: fd2
                                    })
                                        .then(r => r.json())
                                        .then(up => {
                                            if (up.success) {
                                                $('.datatables-services').DataTable().ajax.reload();
                                                Swal.fire({
                                                    title: 'موفق',
                                                    text: up.message,
                                                    icon: 'success',
                                                    confirmButtonText: 'اوکی',
                                                    customClass: {
                                                        confirmButton: 'btn btn-danger me-3 waves-effect waves-light',
                                                    },
                                                    buttonsStyling: false
                                                });
                                            } else {
                                                Swal.fire({
                                                    title: 'خطا',
                                                    text: up.error,
                                                    icon: 'error',
                                                    confirmButtonText: 'اوکی',
                                                    customClass: {
                                                        confirmButton: 'btn btn-danger me-3 waves-effect waves-light',
                                                    },
                                                    buttonsStyling: false
                                                });
                                            }
                                        });
                                }
                            });
                        });
                });
        });

        $(document).on('click', '.delete-service', function() {
            const code = $(this).data('code');
            Swal.fire({
                title: 'حذف خدمت',
                text: 'آیا مطمئنید؟',
                icon: 'warning',
                confirmButtonText: 'بله, حذف کن!',
                cancelButtonText: 'لغو',
                customClass: {
                    confirmButton: 'btn btn-danger me-3 waves-effect waves-light',
                    cancelButton: 'btn btn-label-secondary waves-effect waves-light'
                },
                buttonsStyling: false
            }).then(result => {
                if (result.isConfirmed) {
                    const fd = new FormData();
                    fd.append('action', 'delete_service');
                    fd.append('code', code);
                    fetch('functions/services_funcs.php', { method: 'POST', body: fd })
                        .then(r => r.json())
                        .then(res => {
                            if (res.success) {
                                $('.datatables-services').DataTable().ajax.reload();
                                Swal.fire({
                                    title: 'حذف شد',
                                    text: 'خدمت با موفقیت حذف شد.',
                                    icon: 'success',
                                    confirmButtonText: 'اوکی',
                                    customClass: {
                                        confirmButton: 'btn btn-danger me-3 waves-effect waves-light',
                                    },
                                    buttonsStyling: false
                                });
                            } else {
                                Swal.fire({
                                    title: 'خطا',
                                    text: 'در حذف خدمت مشکلی پیش آمده.',
                                    icon: 'error',
                                    confirmButtonText: 'اوکی',
                                    customClass: {
                                        confirmButton: 'btn btn-danger me-3 waves-effect waves-light',
                                    },
                                    buttonsStyling: false
                                });
                            }
                        });
                }
            });
        });

// ===== CATEGORIES =====
        $(document).on('click', '.edit-category', function() {
            const categoryCode = $(this).data('code');
            const fd = new FormData();
            fd.append('action', 'get_service_category');
            fd.append('code', categoryCode);

            fetch('functions/services_funcs.php', {
                method: 'POST',
                body: fd
            })
                .then(r => r.json())
                .then(data => {
                    if (!data.success) return Swal.fire('خطا', data.error || '', 'error');
                    const c = data.category;
                    Swal.fire({
                        title: 'ویرایش دسته‌بندی',
                        input: 'text',
                        inputValue: c.category_title,
                        showCancelButton: true,
                        confirmButtonText: 'ذخیره تغییرات',
                        cancelButtonText: 'لغو',
                        customClass: {
                            confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                            cancelButton:  'btn btn-label-secondary waves-effect waves-light'
                        },
                        preConfirm: (val) => ({ code: categoryCode, category_title: val })
                    }).then(res => {
                        if (res.isConfirmed) {
                            const fd2 = new FormData();
                            fd2.append('action', 'update_service_category');
                            fd2.append('code', res.value.code);
                            fd2.append('category_title', res.value.category_title);
                            fetch('functions/services_funcs.php', { method: 'POST', body: fd2 })
                                .then(r2 => r2.json())
                                .then(up => {
                                    if (up.success) {
                                        $('.datatables-categories').DataTable().ajax.reload();
                                        refreshServiceCategorySelect();
                                        Swal.fire({
                                            title: 'موفق',
                                            text: up.message,
                                            icon: 'success',
                                            confirmButtonText: 'اوکی',
                                            customClass: {
                                                confirmButton: 'btn btn-danger me-3 waves-effect waves-light',
                                            },
                                            buttonsStyling: false
                                        });
                                    } else {
                                        Swal.fire({
                                            title: 'خطا',
                                            text: up.error,
                                            icon: 'error',
                                            confirmButtonText: 'اوکی',
                                            customClass: {
                                                confirmButton: 'btn btn-danger me-3 waves-effect waves-light',
                                            },
                                            buttonsStyling: false
                                        });
                                    }
                                });
                        }
                    });
                });
        });

        $(document).on('click', '.delete-category', function() {
            const code = $(this).data('code');
            Swal.fire({
                title: 'حذف دسته‌بندی',
                text: 'آیا مطمئنید؟',
                icon: 'warning',
                confirmButtonText: 'بله, حذف کن!',
                cancelButtonText: 'لغو',
                customClass: {
                    confirmButton: 'btn btn-danger me-3 waves-effect waves-light',
                    cancelButton: 'btn btn-label-secondary waves-effect waves-light'
                },
                buttonsStyling: false
            }).then(res => {
                if (res.isConfirmed) {
                    const fd = new FormData();
                    fd.append('action', 'delete_service_category');
                    fd.append('code', code);
                    fetch('functions/services_funcs.php', { method: 'POST', body: fd })
                        .then(r => r.json())
                        .then(resp => {
                            if (resp.success) {
                                $('.datatables-categories').DataTable().ajax.reload();
                                refreshServiceCategorySelect();
                                Swal.fire({
                                    title: 'حذف شد',
                                    text: 'دسته بندی با موفقیت حذف شد.',
                                    icon: 'success',
                                    confirmButtonText: 'اوکی',
                                    customClass: {
                                        confirmButton: 'btn btn-danger me-3 waves-effect waves-light',
                                    },
                                    buttonsStyling: false
                                });
                            } else {
                                Swal.fire({
                                    title: 'خطا',
                                    text: 'در حذف دسته بندی مشکلی پیش آمده.',
                                    icon: 'error',
                                    confirmButtonText: 'اوکی',
                                    customClass: {
                                        confirmButton: 'btn btn-danger me-3 waves-effect waves-light',
                                    },
                                    buttonsStyling: false
                                });
                            }
                        });
                }
            });
        });
    });

    function refreshServiceCategorySelect(selectedVal = '') {
        fetch('functions/services_funcs.php', {
            method: 'POST',
            body: new URLSearchParams({ action: 'fetch_categories_list' })
        })
            .then(res => res.json())
            .then(data => {
                if (data.success && Array.isArray(data.categories)) {
                    const $sel = $('#add-service-category');
                    $sel.empty();
                    data.categories.forEach(cat => {
                        const opt = $('<option>', {
                            value: cat.code,
                            text: cat.title
                        });
                        if (cat.code === selectedVal) opt.prop('selected', true);
                        $sel.append(opt);
                    });
                }
            })
            .catch(err => console.error('Error refreshing categories:', err));
    }
</script>
</body>
</html>
